/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;

public abstract class BiomeSource
implements BiomeResolver {
    public static final Codec<BiomeSource> f_47888_ = Registry.f_122889_.m_194605_().dispatchStable(BiomeSource::m_5820_, Function.identity());
    private final Supplier<Set<Holder<Biome>>> lazyPossibleBiomes = Suppliers.memoize(() -> new ObjectLinkedOpenHashSet((Collection)biomes.get()));

    protected BiomeSource(Stream<Holder<Biome>> p_47896_) {
        this(p_47896_.distinct().toList());
    }

    protected BiomeSource(List<Holder<Biome>> p_47894_) {
        this(() -> p_47894_);
    }

    protected BiomeSource(Supplier<List<Holder<Biome>>> biomes) {
    }

    protected abstract Codec<? extends BiomeSource> m_5820_();

    public Set<Holder<Biome>> m_207840_() {
        return this.lazyPossibleBiomes.get();
    }

    public Set<Holder<Biome>> m_183399_(int p_186705_, int p_186706_, int p_186707_, int p_186708_, Climate.Sampler p_186709_) {
        int i = QuartPos.m_175400_((int)(p_186705_ - p_186708_));
        int j = QuartPos.m_175400_((int)(p_186706_ - p_186708_));
        int k = QuartPos.m_175400_((int)(p_186707_ - p_186708_));
        int l = QuartPos.m_175400_((int)(p_186705_ + p_186708_));
        int i1 = QuartPos.m_175400_((int)(p_186706_ + p_186708_));
        int j1 = QuartPos.m_175400_((int)(p_186707_ + p_186708_));
        int k1 = l - i + 1;
        int l1 = i1 - j + 1;
        int i2 = j1 - k + 1;
        HashSet set = Sets.newHashSet();
        for (int j2 = 0; j2 < i2; ++j2) {
            for (int k2 = 0; k2 < k1; ++k2) {
                for (int l2 = 0; l2 < l1; ++l2) {
                    int i3 = i + k2;
                    int j3 = j + l2;
                    int k3 = k + j2;
                    set.add(this.m_203407_(i3, j3, k3, p_186709_));
                }
            }
        }
        return set;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> m_220570_(int p_220571_, int p_220572_, int p_220573_, int p_220574_, Predicate<Holder<Biome>> p_220575_, RandomSource p_220576_, Climate.Sampler p_220577_) {
        return this.m_213971_(p_220571_, p_220572_, p_220573_, p_220574_, 1, p_220575_, p_220576_, false, p_220577_);
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> m_214004_(BlockPos p_220578_, int p_220579_, int p_220580_, int p_220581_, Predicate<Holder<Biome>> p_220582_, Climate.Sampler p_220583_, LevelReader p_220584_) {
        Set set = this.m_207840_().stream().filter(p_220582_).collect(Collectors.toUnmodifiableSet());
        if (set.isEmpty()) {
            return null;
        }
        int i = Math.floorDiv(p_220579_, p_220580_);
        int[] aint = Mth.m_216250_((int)p_220578_.m_123342_(), (int)(p_220584_.m_141937_() + 1), (int)p_220584_.m_151558_(), (int)p_220581_).toArray();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.m_121935_((BlockPos)BlockPos.f_121853_, (int)i, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = p_220578_.m_123341_() + blockpos$mutableblockpos.m_123341_() * p_220580_;
            int k = p_220578_.m_123343_() + blockpos$mutableblockpos.m_123343_() * p_220580_;
            int l = QuartPos.m_175400_((int)j);
            int i1 = QuartPos.m_175400_((int)k);
            for (int j1 : aint) {
                int k1 = QuartPos.m_175400_((int)j1);
                Holder<Biome> holder = this.m_203407_(l, k1, i1, p_220583_);
                if (!set.contains(holder)) continue;
                return Pair.of((Object)new BlockPos(j, j1, k), holder);
            }
        }
        return null;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> m_213971_(int p_220561_, int p_220562_, int p_220563_, int p_220564_, int p_220565_, Predicate<Holder<Biome>> p_220566_, RandomSource p_220567_, boolean p_220568_, Climate.Sampler p_220569_) {
        int j1;
        int i = QuartPos.m_175400_((int)p_220561_);
        int j = QuartPos.m_175400_((int)p_220563_);
        int k = QuartPos.m_175400_((int)p_220564_);
        int l = QuartPos.m_175400_((int)p_220562_);
        Pair pair = null;
        int i1 = 0;
        for (int k1 = j1 = p_220568_ ? 0 : k; k1 <= k; k1 += p_220565_) {
            int l1;
            int n = l1 = SharedConstants.f_183698_ ? 0 : -k1;
            while (l1 <= k1) {
                boolean flag = Math.abs(l1) == k1;
                for (int i2 = -k1; i2 <= k1; i2 += p_220565_) {
                    int j2;
                    int k2;
                    Holder<Biome> holder;
                    if (p_220568_) {
                        boolean flag1;
                        boolean bl = flag1 = Math.abs(i2) == k1;
                        if (!flag1 && !flag) continue;
                    }
                    if (!p_220566_.test(holder = this.m_203407_(k2 = i + i2, l, j2 = j + l1, p_220569_))) continue;
                    if (pair == null || p_220567_.m_188503_(i1 + 1) == 0) {
                        BlockPos blockpos = new BlockPos(QuartPos.m_175402_((int)k2), p_220562_, QuartPos.m_175402_((int)j2));
                        if (p_220568_) {
                            return Pair.of((Object)blockpos, holder);
                        }
                        pair = Pair.of((Object)blockpos, holder);
                    }
                    ++i1;
                }
                l1 += p_220565_;
            }
        }
        return pair;
    }

    public abstract Holder<Biome> m_203407_(int var1, int var2, int var3, Climate.Sampler var4);

    public void m_207301_(List<String> p_207837_, BlockPos p_207838_, Climate.Sampler p_207839_) {
    }
}

