/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class RemappingVertexPipeline
implements VertexConsumer {
    private static final Set<VertexFormatElement> KNOWN_ELEMENTS = Set.of(DefaultVertexFormat.f_85804_, DefaultVertexFormat.f_85805_, DefaultVertexFormat.f_166849_, DefaultVertexFormat.f_85807_, DefaultVertexFormat.f_85808_, DefaultVertexFormat.f_85809_, DefaultVertexFormat.f_85810_);
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final VertexConsumer parent;
    private final VertexFormat targetFormat;
    private final Vector3d position = new Vector3d(0.0, 0.0, 0.0);
    private final Vector3f normal = new Vector3f(0.0f, 0.0f, 0.0f);
    private final int[] color = new int[]{255, 255, 255, 255};
    private final float[] uv0 = new float[]{0.0f, 0.0f};
    private final int[] uv1 = new int[]{0, 10};
    private final int[] uv2 = new int[]{0, 0};
    private final Map<VertexFormatElement, Integer> miscElementIds;
    private final int[][] misc;

    public RemappingVertexPipeline(VertexConsumer parent, VertexFormat targetFormat) {
        this.parent = parent;
        this.targetFormat = targetFormat;
        this.miscElementIds = new IdentityHashMap<VertexFormatElement, Integer>();
        int i = 0;
        for (VertexFormatElement element : targetFormat.m_86023_()) {
            if (element.m_86048_() == VertexFormatElement.Usage.PADDING || KNOWN_ELEMENTS.contains(element)) continue;
            this.miscElementIds.put(element, i++);
        }
        this.misc = new int[i][];
        Arrays.fill((Object[])this.misc, EMPTY_INT_ARRAY);
    }

    public VertexConsumer m_5483_(double x, double y, double z) {
        this.position.m_176285_(x, y, z);
        return this;
    }

    public VertexConsumer m_5601_(float x, float y, float z) {
        this.normal.m_122245_(x, y, z);
        return this;
    }

    public VertexConsumer m_6122_(int r, int g, int b, int a) {
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        this.color[3] = a;
        return this;
    }

    public VertexConsumer m_7421_(float u, float v) {
        this.uv0[0] = u;
        this.uv0[1] = v;
        return this;
    }

    public VertexConsumer m_7122_(int u, int v) {
        this.uv1[0] = u;
        this.uv1[1] = v;
        return this;
    }

    public VertexConsumer m_7120_(int u, int v) {
        this.uv2[0] = u;
        this.uv2[1] = v;
        return this;
    }

    public VertexConsumer misc(VertexFormatElement element, int ... values) {
        Integer id = this.miscElementIds.get(element);
        if (id != null) {
            this.misc[id.intValue()] = Arrays.copyOf(values, values.length);
        }
        return this;
    }

    public void m_5752_() {
        for (VertexFormatElement element : this.targetFormat.m_86023_()) {
            if (element.m_86048_() == VertexFormatElement.Usage.PADDING) continue;
            if (element.equals((Object)DefaultVertexFormat.f_85804_)) {
                this.parent.m_5483_(this.position.f_86214_, this.position.f_86215_, this.position.f_86216_);
                continue;
            }
            if (element.equals((Object)DefaultVertexFormat.f_85809_)) {
                this.parent.m_5601_(this.normal.m_122239_(), this.normal.m_122260_(), this.normal.m_122269_());
                continue;
            }
            if (element.equals((Object)DefaultVertexFormat.f_85805_)) {
                this.parent.m_6122_(this.color[0], this.color[1], this.color[2], this.color[3]);
                continue;
            }
            if (element.equals((Object)DefaultVertexFormat.f_85806_)) {
                this.parent.m_7421_(this.uv0[0], this.uv0[1]);
                continue;
            }
            if (element.equals((Object)DefaultVertexFormat.f_85807_)) {
                this.parent.m_7122_(this.uv1[0], this.uv1[1]);
                continue;
            }
            if (element.equals((Object)DefaultVertexFormat.f_85808_)) {
                this.parent.m_7120_(this.uv2[0], this.uv2[1]);
                continue;
            }
            this.parent.misc(element, this.misc[this.miscElementIds.get(element)]);
        }
    }

    public void m_7404_(int r, int g, int b, int a) {
        this.parent.m_7404_(r, g, b, a);
    }

    public void m_141991_() {
        this.parent.m_141991_();
    }
}

