/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.TrollAIFleeSun;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.util.WorldUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class EntityTroll
extends Monster
implements IAnimatedEntity,
IVillagerFear,
IHumanoid,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_STRIKE_HORIZONTAL = Animation.create((int)20);
    public static final Animation ANIMATION_STRIKE_VERTICAL = Animation.create((int)20);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_ROAR = Animation.create((int)25);
    public static final ResourceLocation FOREST_LOOT = new ResourceLocation("iceandfire", "entities/troll_forest");
    public static final ResourceLocation FROST_LOOT = new ResourceLocation("iceandfire", "entities/troll_frost");
    public static final ResourceLocation MOUNTAIN_LOOT = new ResourceLocation("iceandfire", "entities/troll_mountain");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityTroll.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WEAPON = SynchedEntityData.m_135353_(EntityTroll.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float stoneProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean avoidSun = true;

    public EntityTroll(EntityType<EntityTroll> t, Level worldIn) {
        super(t, worldIn);
    }

    public static boolean canTrollSpawnOn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && EntityTroll.m_219009_((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)randomIn) && EntityTroll.m_217057_((EntityType)((EntityType)IafEntityRegistry.TROLL.get()), (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, IafConfig.trollMaxHealth).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, IafConfig.trollAttackStrength).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 9.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(IafConfig.trollMaxHealth);
        this.m_21051_(Attributes.f_22281_).m_22100_(IafConfig.trollAttackStrength);
    }

    private void setAvoidSun(boolean day) {
        if (day && !this.avoidSun) {
            ((GroundPathNavigation)this.m_21573_()).m_26490_(true);
            this.avoidSun = true;
        }
        if (!day && this.avoidSun) {
            ((GroundPathNavigation)this.m_21573_()).m_26490_(false);
            this.avoidSun = false;
        }
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    public boolean m_5545_(LevelAccessor worldIn, @NotNull MobSpawnType spawnReasonIn) {
        BlockPos pos = this.m_20183_();
        BlockPos heightAt = worldIn.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
        boolean rngCheck = true;
        return rngCheck && pos.m_123342_() < heightAt.m_123342_() - 10 && super.m_5545_(worldIn, spawnReasonIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new TrollAIFleeSun(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.setAvoidSun(true);
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        if (this.m_217043_().m_188499_()) {
            this.setAnimation(ANIMATION_STRIKE_VERTICAL);
        } else {
            this.setAnimation(ANIMATION_STRIKE_HORIZONTAL);
        }
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(WEAPON, (Object)0);
    }

    private int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public EnumTroll getTrollType() {
        return EnumTroll.values()[this.getVariant()];
    }

    public void setTrollType(EnumTroll variant) {
        this.setVariant(variant.ordinal());
    }

    private int getWeapon() {
        return (Integer)this.f_19804_.m_135370_(WEAPON);
    }

    private void setWeapon(int variant) {
        this.f_19804_.m_135381_(WEAPON, (Object)variant);
    }

    public EnumTroll.Weapon getWeaponType() {
        return EnumTroll.Weapon.values()[this.getWeapon()];
    }

    public void setWeaponType(EnumTroll.Weapon variant) {
        this.setWeapon(variant.ordinal());
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128405_("Weapon", this.getWeapon());
        compound.m_128350_("StoneProgress", this.stoneProgress);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setWeapon(compound.m_128451_("Weapon"));
        this.stoneProgress = compound.m_128457_("StoneProgress");
        this.setConfigurableAttributes();
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setTrollType(EnumTroll.getBiomeType((Holder<Biome>)this.f_19853_.m_204166_(this.m_20183_())));
        this.setWeaponType(EnumTroll.getWeaponForType(this.getTrollType()));
        return spawnDataIn;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_19385_().contains("arrow")) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    @Nullable
    protected ResourceLocation m_7582_() {
        switch (this.getTrollType()) {
            case MOUNTAIN: {
                return MOUNTAIN_LOOT;
            }
            case FROST: {
                return FROST_LOOT;
            }
            case FOREST: {
                return FOREST_LOOT;
            }
        }
        return null;
    }

    public int m_213860_() {
        return 15;
    }

    protected void m_6153_() {
        super.m_6153_();
        if (this.f_20919_ == 20 && !this.f_19853_.f_46443_ && IafConfig.trollsDropWeapon) {
            if (this.m_217043_().m_188503_(3) == 0) {
                ItemStack weaponStack = new ItemStack((ItemLike)this.getWeaponType().item.get(), 1);
                weaponStack.m_220157_(this.m_217043_().m_188503_(250), this.m_217043_(), null);
                this.dropItemAt(weaponStack, this.m_20185_(), this.m_20186_(), this.m_20189_());
            } else {
                ItemStack brokenDrop = new ItemStack((ItemLike)Blocks.f_50222_, this.m_217043_().m_188503_(2) + 1);
                ItemStack brokenDrop2 = new ItemStack((ItemLike)Blocks.f_50222_, this.m_217043_().m_188503_(2) + 1);
                if (this.getWeaponType() == EnumTroll.Weapon.AXE) {
                    brokenDrop = new ItemStack((ItemLike)Items.f_42398_, this.m_217043_().m_188503_(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.f_50652_, this.m_217043_().m_188503_(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.f_50222_, this.m_217043_().m_188503_(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.f_50222_, this.m_217043_().m_188503_(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN_FOREST) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.f_50222_, this.m_217043_().m_188503_(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.f_50222_, this.m_217043_().m_188503_(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN_FROST) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.f_50222_, this.m_217043_().m_188503_(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Items.f_42452_, this.m_217043_().m_188503_(4) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.HAMMER) {
                    brokenDrop = new ItemStack((ItemLike)Items.f_42500_, this.m_217043_().m_188503_(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.f_50652_, this.m_217043_().m_188503_(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.TRUNK) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.f_49999_, this.m_217043_().m_188503_(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.f_49999_, this.m_217043_().m_188503_(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.TRUNK_FROST) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.f_50000_, this.m_217043_().m_188503_(4) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Items.f_42452_, this.m_217043_().m_188503_(4) + 1);
                }
                this.dropItemAt(brokenDrop, this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.dropItemAt(brokenDrop2, this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
        }
    }

    @Nullable
    private ItemEntity dropItemAt(ItemStack stack, double x, double y, double z) {
        if (stack.m_41613_() > 0) {
            ItemEntity entityitem = new ItemEntity(this.f_19853_, x, y, z, stack);
            entityitem.m_32060_();
            this.f_19853_.m_7967_((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public void m_8107_() {
        boolean stone;
        super.m_8107_();
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_6710_(null);
        }
        if ((stone = EntityGorgon.isStoneMob((LivingEntity)this)) && this.stoneProgress < 20.0f) {
            this.stoneProgress += 2.0f;
        } else if (!stone && this.stoneProgress > 0.0f) {
            this.stoneProgress -= 2.0f;
        }
        if (!stone && this.getAnimation() == NO_ANIMATION && this.m_5448_() != null && this.m_217043_().m_188503_(100) == 0) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.m_5496_(IafSoundRegistry.TROLL_ROAR, 1.0f, 1.0f);
        }
        if (!stone && this.m_21223_() < this.m_21233_() && this.f_19797_ % 30 == 0) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 30, 1, false, false));
        }
        this.setAvoidSun(this.f_19853_.m_46461_());
        if (this.f_19853_.m_46461_() && !this.f_19853_.f_46443_) {
            BlockPos blockpos;
            float f = this.f_19853_.m_45517_(LightLayer.SKY, this.m_20183_());
            BlockPos blockPos = blockpos = this.m_20202_() instanceof Boat ? new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_()).m_7494_() : new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
            if (f > 0.5f && this.f_19853_.m_45527_(blockpos)) {
                this.m_20334_(0.0, 0.0, 0.0);
                this.setAnimation(NO_ANIMATION);
                this.m_5496_(IafSoundRegistry.TURN_STONE, 1.0f, 1.0f);
                this.stoneProgress = 20.0f;
                EntityStoneStatue statue = EntityStoneStatue.buildStatueEntity((LivingEntity)this);
                statue.getTrappedTag().m_128350_("StoneProgress", 20.0f);
                statue.m_19890_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7967_((Entity)statue);
                }
                statue.f_19859_ = this.m_146908_();
                statue.m_146922_(this.m_146908_());
                statue.f_20885_ = this.m_146908_();
                statue.f_20883_ = this.m_146908_();
                statue.f_20884_ = this.m_146908_();
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            float weaponX = (float)(this.m_20185_() + (double)(1.9f * Mth.m_14089_((float)((float)((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0)))));
            float weaponZ = (float)(this.m_20189_() + (double)(1.9f * Mth.m_14031_((float)((float)((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0)))));
            float weaponY = (float)(this.m_20186_() + (double)0.2f);
            BlockState state = this.f_19853_.m_8055_(WorldUtil.containing(weaponX, weaponY - 1.0f, weaponZ));
            for (int i = 0; i < 20; ++i) {
                double motionX = this.m_217043_().m_188583_() * 0.07;
                double motionY = this.m_217043_().m_188583_() * 0.07;
                double motionZ = this.m_217043_().m_188583_() * 0.07;
                if (!state.m_60767_().m_76333_() || !this.f_19853_.f_46443_) continue;
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)(weaponX + (this.m_217043_().m_188501_() - 0.5f)), (double)(weaponY + (this.m_217043_().m_188501_() - 0.5f)), (double)(weaponZ + (this.m_217043_().m_188501_() - 0.5f)), motionX, motionY, motionZ);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 4.0 && this.getAnimationTick() == 10 && this.f_20919_ <= 0) {
            this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 4.0 && this.getAnimationTick() == 10 && this.f_20919_ <= 0) {
            LivingEntity target = this.m_5448_();
            target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
            float f1 = 0.5f;
            float f2 = target.f_20902_;
            float f3 = 0.6f;
            float f4 = Mth.m_14116_((float)(f2 * f2 + f3 * f3));
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f1 / f4;
            f2 *= f4;
            f3 *= f4;
            float f5 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f6 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            target.m_20334_((double)f5, (double)f6, (double)0.4f);
        }
        if (this.m_21573_().m_26571_() && this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 3.0 && this.m_20280_((Entity)this.m_5448_()) < 30.0 && this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
            this.m_21391_((Entity)this.m_5448_(), 30.0f, 30.0f);
            if (this.getAnimation() == NO_ANIMATION && this.f_19796_.m_188503_(15) == 0) {
                this.setAnimation(ANIMATION_STRIKE_VERTICAL);
            }
            if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
                float weaponX = (float)(this.m_20185_() + (double)(1.9f * Mth.m_14089_((float)((float)((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0)))));
                float weaponZ = (float)(this.m_20189_() + (double)(1.9f * Mth.m_14031_((float)((float)((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0)))));
                float weaponY = (float)(this.m_20186_() + (double)(this.m_20192_() / 2.0f));
                Explosion explosion = new Explosion(this.f_19853_, (Entity)this, (double)weaponX, (double)weaponY, (double)weaponZ, 1.0f + this.m_217043_().m_188501_(), new ArrayList());
                if (!MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, weaponX, weaponY, weaponZ))) {
                    explosion.m_46061_();
                    explosion.m_46075_(true);
                }
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            this.m_5496_(SoundEvents.f_12317_, 2.5f, 0.5f);
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.getAnimationTick() == 10) {
            this.m_5496_(SoundEvents.f_12317_, 2.5f, 0.5f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_8032_();
    }

    protected void m_6677_(@NotNull DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_6677_(source);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return IafSoundRegistry.TROLL_IDLE;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return IafSoundRegistry.TROLL_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return IafSoundRegistry.TROLL_DIE;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_STRIKE_HORIZONTAL, ANIMATION_STRIKE_VERTICAL, ANIMATION_SPEAK, ANIMATION_ROAR};
    }
}

