/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class SeaSerpentAIJump
extends JumpGoal {
    private static final int[] JUMP_DISTANCES = new int[]{0, 2, 4, 5, 6, 7};
    private final EntitySeaSerpent serpent;
    private final int chance;
    private boolean inWater;

    public SeaSerpentAIJump(EntitySeaSerpent dolphin, int chance) {
        this.serpent = dolphin;
        this.chance = chance;
    }

    public boolean m_8036_() {
        if (this.serpent.m_217043_().m_188503_(this.chance) != 0 || this.serpent.m_5448_() != null || this.serpent.jumpCooldown != 0) {
            return false;
        }
        Direction direction = this.serpent.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockpos = this.serpent.m_20183_();
        for (int k : JUMP_DISTANCES) {
            if (this.canJumpTo(blockpos, i, j, k) && this.isAirAbove(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.m_7918_(dx * scale, 0, dz * scale);
        return this.serpent.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.serpent.f_19853_.m_8055_(blockpos).m_60767_().m_76334_();
    }

    private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
        return this.serpent.f_19853_.m_8055_(pos.m_7918_(dx * scale, 1, dz * scale)).m_60795_() && this.serpent.f_19853_.m_8055_(pos.m_7918_(dx * scale, 2, dz * scale)).m_60795_();
    }

    public boolean m_8045_() {
        double d0 = this.serpent.m_20184_().f_82480_;
        return this.serpent.jumpCooldown > 0 && (d0 * d0 >= (double)0.03f || this.serpent.m_146909_() == 0.0f || Math.abs(this.serpent.m_146909_()) >= 10.0f || !this.serpent.m_20069_()) && !this.serpent.m_20096_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        Direction direction = this.serpent.m_6374_();
        float up = 1.0f + this.serpent.m_217043_().m_188501_() * 0.8f;
        this.serpent.m_20256_(this.serpent.m_20184_().m_82520_((double)direction.m_122429_() * 0.6, (double)up, (double)direction.m_122431_() * 0.6));
        this.serpent.setJumpingOutOfWater(true);
        this.serpent.m_21573_().m_26573_();
        this.serpent.jumpCooldown = this.serpent.m_217043_().m_188503_(100) + 100;
    }

    public void m_8041_() {
        this.serpent.setJumpingOutOfWater(false);
        this.serpent.m_146926_(0.0f);
    }

    public void m_8037_() {
        boolean flag = this.inWater;
        if (!flag) {
            FluidState fluidstate = this.serpent.f_19853_.m_6425_(this.serpent.m_20183_());
            this.inWater = fluidstate.m_205070_(FluidTags.f_13131_);
        }
        if (this.inWater && !flag) {
            this.serpent.m_5496_(SoundEvents.f_11805_, 1.0f, 1.0f);
        }
        Vec3 vector3d = this.serpent.m_20184_();
        if (vector3d.f_82480_ * vector3d.f_82480_ < (double)0.1f && this.serpent.m_146909_() != 0.0f) {
            this.serpent.m_146926_(Mth.m_14189_((float)this.serpent.m_146909_(), (float)0.0f, (float)0.2f));
        } else {
            double d0 = vector3d.m_165924_();
            double d1 = Math.signum(-vector3d.f_82480_) * Math.acos(d0 / vector3d.m_82553_()) * 57.2957763671875;
            this.serpent.m_146926_((float)d1);
        }
    }
}

