/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.datagen.tags.IafItemTags;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.IafVillagerRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AiDebug;
import com.github.alexthe666.iceandfire.entity.ai.EntitySheepAIFollowCyclops;
import com.github.alexthe666.iceandfire.entity.ai.VillagerAIFearUntamed;
import com.github.alexthe666.iceandfire.entity.props.ChainProperties;
import com.github.alexthe666.iceandfire.entity.props.ChickenProperties;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.props.SirenProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IHearsSiren;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemChain;
import com.github.alexthe666.iceandfire.item.ItemCockatriceScepter;
import com.github.alexthe666.iceandfire.item.ItemDeathwormGauntlet;
import com.github.alexthe666.iceandfire.item.ItemDragonsteelArmor;
import com.github.alexthe666.iceandfire.item.ItemGhostSword;
import com.github.alexthe666.iceandfire.item.ItemScaleArmor;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import com.github.alexthe666.iceandfire.message.MessagePlayerHitMultipart;
import com.github.alexthe666.iceandfire.message.MessageSwingArm;
import com.github.alexthe666.iceandfire.message.MessageSyncPath;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.MNode;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonCave;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="iceandfire")
public class ServerEvents {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    private static final Predicate<LivingEntity> VILLAGER_FEAR = entity -> entity instanceof IVillagerFear;
    private final Random rand = new Random();
    private static final String[] VILLAGE_TYPES = new String[]{"plains", "desert", "snowy", "savanna", "taiga"};
    public static String BOLT_DONT_DESTROY_LOOT = "iceandfire.bolt_skip_loot";

    private static void signalChickenAlarm(LivingEntity chicken, LivingEntity attacker) {
        float d0 = IafConfig.cockatriceChickenSearchLength;
        List list = chicken.f_19853_.m_45976_(EntityCockatrice.class, new AABB(chicken.m_20185_(), chicken.m_20186_(), chicken.m_20189_(), chicken.m_20185_() + 1.0, chicken.m_20186_() + 1.0, chicken.m_20189_() + 1.0).m_82377_((double)d0, 10.0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (EntityCockatrice cockatrice : list) {
            if (attacker instanceof EntityCockatrice || DragonUtils.hasSameOwner(cockatrice, (Entity)attacker)) continue;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                if (player.m_7500_() || cockatrice.m_21830_((LivingEntity)player)) continue;
                cockatrice.m_6710_((LivingEntity)player);
                continue;
            }
            cockatrice.m_6710_(attacker);
        }
    }

    private static void signalAmphithereAlarm(LivingEntity villager, LivingEntity attacker) {
        float d0 = IafConfig.amphithereVillagerSearchLength;
        List list = villager.f_19853_.m_45976_(EntityAmphithere.class, new AABB(villager.m_20185_() - 1.0, villager.m_20186_() - 1.0, villager.m_20189_() - 1.0, villager.m_20185_() + 1.0, villager.m_20186_() + 1.0, villager.m_20189_() + 1.0).m_82377_((double)d0, (double)d0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            if (!(entity instanceof EntityAmphithere)) continue;
            EntityAmphithere amphithere = (EntityAmphithere)entity;
            if (attacker instanceof EntityAmphithere || DragonUtils.hasSameOwner(amphithere, (Entity)attacker)) continue;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                if (player.m_7500_() || amphithere.m_21830_((LivingEntity)player)) continue;
                amphithere.m_6710_((LivingEntity)player);
                continue;
            }
            amphithere.m_6710_(attacker);
        }
    }

    private static boolean isInEntityTag(ResourceLocation loc, EntityType<?> type) {
        return type.m_204039_(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).createTagKey(loc));
    }

    public static boolean isLivestock(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.FEAR_DRAGONS, entity.m_6095_());
    }

    public static boolean isVillager(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.VILLAGERS, entity.m_6095_());
    }

    public static boolean isSheep(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.SHEEP, entity.m_6095_());
    }

    public static boolean isChicken(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.CHICKENS, entity.m_6095_());
    }

    public static boolean isCockatriceTarget(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.COCKATRICE_TARGETS, entity.m_6095_());
    }

    public static boolean doesScareCockatrice(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.SCARES_COCKATRICES, entity.m_6095_());
    }

    public static boolean isBlindMob(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.BLINDED, entity.m_6095_());
    }

    public static boolean isRidingOrBeingRiddenBy(Entity first, Entity entityIn) {
        for (Entity entity : first.m_20197_()) {
            if (!entity.equals((Object)entityIn) && !ServerEvents.isRidingOrBeingRiddenBy(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onArrowCollide(ProjectileImpactEvent event) {
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult result = (EntityHitResult)hitResult;
            Entity shotEntity = result.m_82443_();
            if (shotEntity instanceof EntityGhost) {
                event.setCanceled(true);
            } else {
                TamableAnimal tamable;
                Entity shootingEntity;
                AbstractArrow arrow;
                Entity entity = event.getEntity();
                if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_37282_() != null && (shootingEntity = arrow.m_37282_()) instanceof LivingEntity && ServerEvents.isRidingOrBeingRiddenBy(shootingEntity, shotEntity) && shotEntity instanceof TamableAnimal && (tamable = (TamableAnimal)shotEntity).m_21824_() && shotEntity.m_7307_(shootingEntity)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        if (IafConfig.villagerHouseWeight > 0) {
            Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122884_).orElseThrow();
            Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122883_).orElseThrow();
            for (String type : VILLAGE_TYPES) {
                IafVillagerRegistry.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("village/" + type + "/houses"), "iceandfire:village/" + type + "_scriber_1", IafConfig.villagerHouseWeight);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttackMob(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityMutlipartPart && event.getEntity() instanceof Player) {
            event.setCanceled(true);
            Entity parent = ((EntityMutlipartPart)event.getTarget()).getParent();
            try {
                if (parent != null) {
                    event.getEntity().m_5706_(parent);
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Exception thrown while interacting with entity.", (Throwable)e);
            }
            int extraData = 0;
            if (event.getTarget() instanceof EntityHydraHead && parent instanceof EntityHydra) {
                extraData = ((EntityHydraHead)event.getTarget()).headIndex;
                ((EntityHydra)parent).triggerHeadFlags(extraData);
            }
            if (event.getTarget().f_19853_.f_46443_ && parent != null) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessagePlayerHitMultipart(parent.m_19879_(), extraData));
            }
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player && MiscProperties.hasDismounted(event.getEntity())) {
            event.setDamageMultiplier(0.0f);
            MiscProperties.setDismountedDragon(event.getEntity(), false);
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        String damageType;
        if (event.getSource().m_19360_()) {
            float multi = 1.0f;
            if (event.getEntity().m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.1f;
            }
            if (event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.3f;
            }
            if (event.getEntity().m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.2f;
            }
            if (event.getEntity().m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.1f;
            }
            event.setAmount(event.getAmount() * multi);
        }
        if ("dragon_fire".equals(damageType = event.getSource().m_19385_()) || "dragon_ice".equals(damageType) || "dragon_lightning".equals(damageType)) {
            float multi = 1.0f;
            if (event.getEntity().m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemScaleArmor || event.getEntity().m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemDragonsteelArmor) {
                multi -= 0.1f;
            }
            if (event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ItemScaleArmor || event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ItemDragonsteelArmor) {
                multi -= 0.3f;
            }
            if (event.getEntity().m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemScaleArmor || event.getEntity().m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemDragonsteelArmor) {
                multi -= 0.2f;
            }
            if (event.getEntity().m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ItemScaleArmor || event.getEntity().m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ItemDragonsteelArmor) {
                multi -= 0.1f;
            }
            event.setAmount(event.getAmount() * multi);
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        if (event.getEntity() instanceof WitherSkeleton) {
            event.getDrops().add(new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), new ItemStack((ItemLike)IafItemRegistry.WITHERBONE.get(), event.getEntity().m_217043_().m_188503_(2))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void makeItemDropsFireImmune(LivingDropsEvent event) {
        LightningBolt bolt;
        boolean makeFireImmune = false;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof LightningBolt && (bolt = (LightningBolt)entity).m_19880_().contains(BOLT_DONT_DESTROY_LOOT)) {
            makeFireImmune = true;
        } else {
            Player player;
            entity = event.getSource().m_7639_();
            if (entity instanceof Player && (player = (Player)entity).m_21120_(player.m_7655_()).m_204117_(IafItemTags.MAKE_ITEM_DROPS_FIREIMMUNE)) {
                makeFireImmune = true;
            }
        }
        if (makeFireImmune) {
            Set fireImmuneDrops = event.getDrops().stream().map(itemEntity -> new ItemEntity(itemEntity.f_19853_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), itemEntity.m_32055_()){

                public boolean m_5825_() {
                    return true;
                }
            }).collect(Collectors.toSet());
            event.getDrops().clear();
            event.getDrops().addAll(fireImmuneDrops);
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        Entity attacker;
        if (event.getSource() != null && event.getSource().m_7639_() != null && (attacker = event.getSource().m_7639_()) instanceof LivingEntity) {
            if (MiscProperties.getLoveTicks((LivingEntity)attacker) > 0) {
                event.setCanceled(true);
            }
            if (ServerEvents.isChicken((Entity)event.getEntity())) {
                ServerEvents.signalChickenAlarm(event.getEntity(), (LivingEntity)attacker);
            } else if (DragonUtils.isVillager((Entity)event.getEntity())) {
                ServerEvents.signalAmphithereAlarm(event.getEntity(), (LivingEntity)attacker);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingChangeTargetEvent event) {
        LivingEntity target = event.getOriginalTarget();
        if (target != null) {
            LivingEntity attacker = event.getEntity();
            if (ServerEvents.isChicken((Entity)target)) {
                ServerEvents.signalChickenAlarm(target, attacker);
            } else if (DragonUtils.isVillager((Entity)target)) {
                ServerEvents.signalAmphithereAlarm(target, attacker);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        Object list;
        if (event.getTarget() != null && ServerEvents.isSheep(event.getTarget())) {
            float dist = IafConfig.cyclopesSheepSearchLength;
            list = event.getTarget().f_19853_.m_45933_((Entity)event.getEntity(), event.getEntity().m_20191_().m_82363_((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    EntityCyclops cyclops;
                    Entity entity = (Entity)iterator.next();
                    if (!(entity instanceof EntityCyclops) || (cyclops = (EntityCyclops)entity).isBlinded() || event.getEntity().m_7500_()) continue;
                    cyclops.m_6710_((LivingEntity)event.getEntity());
                }
            }
        }
        if ((list = event.getTarget()) instanceof EntityStoneStatue) {
            EntityStoneStatue statue = (EntityStoneStatue)list;
            statue.m_21153_(statue.m_21233_());
            if (event.getEntity() != null) {
                ItemStack stack = event.getEntity().m_21205_();
                event.getTarget().m_5496_(SoundEvents.f_12442_, 2.0f, 0.5f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.5f);
                if (stack.m_41720_().m_8096_(Blocks.f_50069_.m_49966_()) || stack.m_41720_().m_5524_().contains("pickaxe")) {
                    event.setCanceled(true);
                    statue.setCrackAmount(statue.getCrackAmount() + 1);
                    if (statue.getCrackAmount() > 9) {
                        CompoundTag writtenTag = new CompoundTag();
                        event.getTarget().m_20240_(writtenTag);
                        event.getTarget().m_5496_(SoundEvents.f_12442_, 2.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.5f);
                        event.getTarget().m_142687_(Entity.RemovalReason.KILLED);
                        if (stack.getEnchantmentLevel(Enchantments.f_44985_) > 0) {
                            ItemStack statuette = new ItemStack((ItemLike)IafItemRegistry.STONE_STATUE.get());
                            CompoundTag tag = statuette.m_41784_();
                            tag.m_128379_("IAFStoneStatuePlayerEntity", statue.getTrappedEntityTypeString().equalsIgnoreCase("minecraft:player"));
                            tag.m_128359_("IAFStoneStatueEntityID", statue.getTrappedEntityTypeString());
                            tag.m_128365_("IAFStoneStatueNBT", (Tag)writtenTag);
                            statue.m_7380_(tag);
                            if (!statue.f_19853_.m_5776_()) {
                                statue.m_5552_(statuette, 1.0f);
                            }
                        } else if (!statue.f_19853_.m_5776_()) {
                            statue.m_20000_((ItemLike)Blocks.f_50652_.m_5456_(), 2 + event.getEntity().m_217043_().m_188503_(4));
                        }
                        statue.m_142687_(Entity.RemovalReason.KILLED);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDie(LivingDeathEvent event) {
        LivingEntity attacker;
        if (!event.getEntity().f_19853_.f_46443_ && ChainProperties.hasChainData(event.getEntity())) {
            ItemEntity entityitem = new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 1.0, event.getEntity().m_20189_(), new ItemStack((ItemLike)IafItemRegistry.CHAIN.get(), ChainProperties.getChainedTo(event.getEntity()).size()));
            entityitem.m_32060_();
            event.getEntity().f_19853_.m_7967_((Entity)entityitem);
            ChainProperties.clearChainData(event.getEntity());
        }
        if (event.getEntity().m_20148_().equals(ALEX_UUID)) {
            event.getEntity().m_5552_(new ItemStack((ItemLike)IafItemRegistry.WEEZER_BLUE_ALBUM.get()), 1.0f);
        }
        if (event.getEntity() instanceof Player && IafConfig.ghostsFromPlayerDeaths && (attacker = event.getEntity().m_21188_()) instanceof Player && event.getEntity().m_217043_().m_188503_(3) == 0) {
            boolean flag;
            CombatTracker combat = event.getEntity().m_21231_();
            CombatEntry entry = combat.m_19298_();
            boolean bl = flag = entry != null && (entry.m_19263_() == DamageSource.f_19315_ || entry.m_19263_() == DamageSource.f_19312_ || entry.m_19263_() == DamageSource.f_19308_);
            if (event.getEntity().m_21023_(MobEffects.f_19614_)) {
                flag = true;
            }
            if (flag) {
                Level world = event.getEntity().f_19853_;
                EntityGhost ghost = (EntityGhost)((EntityType)IafEntityRegistry.GHOST.get()).m_20615_(world);
                ghost.m_20359_((Entity)event.getEntity());
                if (!world.f_46443_) {
                    ghost.m_6518_((ServerLevelAccessor)world, world.m_6436_(event.getEntity().m_20183_()), MobSpawnType.SPAWNER, null, null);
                    world.m_7967_((Entity)ghost);
                }
                ghost.setDaytimeMode(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityStopUsingItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getItem().m_41720_() instanceof ItemDeathwormGauntlet || event.getItem().m_41720_() instanceof ItemCockatriceScepter) {
            event.setDuration(20);
        }
    }

    @SubscribeEvent
    public void onEntityUseItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity() != null && event.getEntity().m_146909_() > 87.0f && event.getEntity().m_20202_() != null && event.getEntity().m_20202_() instanceof EntityDragonBase) {
            ((EntityDragonBase)event.getEntity().m_20202_()).m_6071_(event.getEntity(), event.getHand());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        if (ChainProperties.hasChainData(event.getEntity())) {
            ChainProperties.tickChain(event.getEntity());
        }
        if (IafConfig.chickensLayRottenEggs && !event.getEntity().f_19853_.f_46443_ && ServerEvents.isChicken((Entity)event.getEntity()) && !event.getEntity().m_6162_() && event.getEntity() instanceof Animal) {
            ChickenProperties.tickChicken(event.getEntity());
        }
        if (FrozenProperties.isFrozen(event.getEntity())) {
            FrozenProperties.tickFrozenEntity(event.getEntity());
            if (!(event.getEntity() instanceof Player) || !((Player)event.getEntity()).m_7500_()) {
                event.getEntity().m_20256_(event.getEntity().m_20184_().m_82542_(0.25, 1.0, 0.25));
                if (!(event.getEntity() instanceof EnderDragon) && !event.getEntity().m_20096_()) {
                    event.getEntity().m_20256_(event.getEntity().m_20184_().m_82520_(0.0, -0.2, 0.0));
                }
            }
        }
        if (event.getEntity() instanceof Player || event.getEntity() instanceof AbstractVillager || event.getEntity() instanceof IHearsSiren) {
            SirenProperties.tickCharmedEntity(event.getEntity());
        }
        if (MiscProperties.getLoveTicks(event.getEntity()) > 0) {
            MiscProperties.tickLove(event.getEntity());
        }
        if (AiDebug.isEnabled() && event.getEntity() instanceof Mob && AiDebug.contains((Mob)event.getEntity())) {
            AiDebug.logData();
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        LivingEntity target;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && ChainProperties.isChainedTo(target = (LivingEntity)entity, (Entity)event.getEntity())) {
            ChainProperties.removeChain(target, (Entity)event.getEntity());
            if (!event.getLevel().f_46443_) {
                event.getTarget().m_20000_((ItemLike)IafItemRegistry.CHAIN.get(), 1);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if (!event.getLevel().m_5776_() && event.getTarget() instanceof Mob && event.getItemStack().m_41720_() == Items.f_42398_) {
            if (AiDebug.isEnabled()) {
                AiDebug.addEntity((Mob)event.getTarget());
            }
            if (Pathfinding.isDebug()) {
                if (AbstractPathJob.trackingMap.getOrDefault(event.getEntity(), UUID.randomUUID()).equals(event.getTarget().m_20148_())) {
                    AbstractPathJob.trackingMap.remove(event.getEntity());
                    IceAndFire.sendMSGToPlayer(new MessageSyncPath(new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>()), (ServerPlayer)event.getEntity());
                } else {
                    AbstractPathJob.trackingMap.put(event.getEntity(), event.getTarget().m_20148_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ServerEvents.onLeftClick(event.getEntity(), event.getItemStack());
        if (event.getLevel().f_46443_) {
            IceAndFire.sendMSGToServer(new MessageSwingArm());
        }
    }

    public static void onLeftClick(Player playerEntity, ItemStack stack) {
        if (stack.m_41720_() == IafItemRegistry.GHOST_SWORD.get()) {
            ItemGhostSword.spawnGhostSwordEntity(stack, playerEntity);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity() != null && event.getLevel().m_8055_(event.getPos()).m_60734_() instanceof AbstractChestBlock && !event.getEntity().m_7500_()) {
            float dist = IafConfig.dragonGoldSearchLength;
            List list = event.getLevel().m_45933_((Entity)event.getEntity(), event.getEntity().m_20191_().m_82377_((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).m_21824_() || dragon.isModelDead() || dragon.m_21830_((LivingEntity)event.getEntity())) continue;
                    dragon.m_21837_(false);
                    dragon.m_21839_(false);
                    dragon.m_6710_((LivingEntity)event.getEntity());
                }
            }
        }
        if (event.getLevel().m_8055_(event.getPos()).m_60734_() instanceof WallBlock) {
            ItemChain.attachToFence(event.getEntity(), event.getLevel(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && (event.getState().m_60734_() instanceof AbstractChestBlock || event.getState().m_60734_() == IafBlockRegistry.GOLD_PILE.get() || event.getState().m_60734_() == IafBlockRegistry.SILVER_PILE.get() || event.getState().m_60734_() == IafBlockRegistry.COPPER_PILE.get())) {
            float dist = IafConfig.dragonGoldSearchLength;
            List list = event.getLevel().m_45933_((Entity)event.getPlayer(), event.getPlayer().m_20191_().m_82377_((double)dist, (double)dist, (double)dist));
            if (list.isEmpty()) {
                return;
            }
            for (Entity entity : list) {
                EntityDragonBase dragon;
                if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).m_21824_() || dragon.isModelDead() || dragon.m_21830_((LivingEntity)event.getPlayer()) || event.getPlayer().m_7500_()) continue;
                dragon.m_21837_(false);
                dragon.m_21839_(false);
                dragon.m_6710_((LivingEntity)event.getPlayer());
            }
        }
    }

    public static void onChestGenerated(LootTableLoadEvent event) {
        LootPool.Builder builder;
        LootPoolSingletonContainer.Builder item;
        boolean condition1;
        ResourceLocation eventName = event.getName();
        boolean bl = condition1 = eventName.equals((Object)BuiltInLootTables.f_78742_) || eventName.equals((Object)BuiltInLootTables.f_78759_) || eventName.equals((Object)BuiltInLootTables.f_78764_) || eventName.equals((Object)BuiltInLootTables.f_78686_) || eventName.equals((Object)BuiltInLootTables.f_78763_) || eventName.equals((Object)BuiltInLootTables.f_78762_);
        if (condition1 || eventName.equals((Object)BuiltInLootTables.f_78746_)) {
            item = LootItem.m_79579_((ItemLike)((ItemLike)IafItemRegistry.MANUSCRIPT.get())).m_79711_(20).m_79707_(5);
            builder = new LootPool.Builder().name("iaf_manuscript").m_79076_((LootPoolEntryContainer.Builder)item).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.35f)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f));
            event.getTable().addPool(builder.m_79082_());
        }
        if (condition1 || eventName.equals((Object)BuiltInLootTables.f_78688_) || eventName.equals((Object)BuiltInLootTables.f_78689_) || eventName.equals((Object)BuiltInLootTables.f_78744_) || eventName.equals((Object)BuiltInLootTables.f_78745_)) {
            item = LootItem.m_79579_((ItemLike)((ItemLike)IafItemRegistry.SILVER_INGOT.get())).m_79711_(15).m_79707_(12);
            builder = new LootPool.Builder().name("iaf_silver_ingot").m_79076_((LootPoolEntryContainer.Builder)item).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.5f)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f));
            event.getTable().addPool(builder.m_79082_());
        } else if (event.getName().equals((Object)WorldGenFireDragonCave.FIRE_DRAGON_CHEST) || event.getName().equals((Object)WorldGenFireDragonCave.FIRE_DRAGON_CHEST_MALE) || event.getName().equals((Object)WorldGenIceDragonCave.ICE_DRAGON_CHEST) || event.getName().equals((Object)WorldGenIceDragonCave.ICE_DRAGON_CHEST_MALE) || event.getName().equals((Object)WorldGenLightningDragonCave.LIGHTNING_DRAGON_CHEST) || event.getName().equals((Object)WorldGenLightningDragonCave.LIGHTNING_DRAGON_CHEST_MALE)) {
            item = LootItem.m_79579_((ItemLike)((ItemLike)IafItemRegistry.WEEZER_BLUE_ALBUM.get())).m_79711_(100).m_79707_(1);
            builder = new LootPool.Builder().name("iaf_weezer").m_79076_((LootPoolEntryContainer.Builder)item).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.01f)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f));
            event.getTable().addPool(builder.m_79082_());
        }
    }

    @SubscribeEvent
    public void onPlayerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() != null && !event.getEntity().m_20197_().isEmpty()) {
            for (Entity entity : event.getEntity().m_20197_()) {
                entity.m_8127_();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (ChainProperties.hasChainData(target)) {
                ChainProperties.updateData(target);
            }
            if (FrozenProperties.isFrozen(target)) {
                FrozenProperties.updateData(target);
            }
            if (MiscProperties.getLoveTicks(target) > 0) {
                MiscProperties.updateData(target);
            }
            if (SirenProperties.isCharmed(target)) {
                SirenProperties.updateData(target);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Mob) {
            Mob mob = (Mob)entity2;
            try {
                Entity entity3;
                if (event.getEntity() != null && ServerEvents.isSheep(event.getEntity()) && (entity3 = event.getEntity()) instanceof Animal) {
                    Animal animal = (Animal)entity3;
                    animal.f_21345_.m_25352_(8, (Goal)new EntitySheepAIFollowCyclops(animal, 1.2));
                }
                if (event.getEntity() != null && ServerEvents.isVillager(event.getEntity()) && event.getEntity() != null && IafConfig.villagersFearDragons) {
                    mob.f_21345_.m_25352_(1, (Goal)new VillagerAIFearUntamed((PathfinderMob)mob, LivingEntity.class, 8.0f, 0.8, 0.8, VILLAGER_FEAR));
                }
                if (event.getEntity() != null && ServerEvents.isLivestock(event.getEntity()) && event.getEntity() != null && IafConfig.animalsFearDragons) {
                    mob.f_21345_.m_25352_(1, (Goal)new VillagerAIFearUntamed((PathfinderMob)mob, LivingEntity.class, 30.0f, 1.0, 0.5, entity -> {
                        IAnimalFear iAnimalFear;
                        return entity instanceof IAnimalFear && (iAnimalFear = (IAnimalFear)entity).shouldAnimalsFear((Entity)mob);
                    }));
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
            }
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == IafVillagerRegistry.SCRIBE.get()) {
            IafVillagerRegistry.addScribeTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        }
    }

    @SubscribeEvent
    public void onLightningHit(EntityStruckByLightningEvent event) {
        if ((event.getEntity() instanceof ItemEntity || event.getEntity() instanceof ExperienceOrb) && event.getLightning().m_19880_().contains(BOLT_DONT_DESTROY_LOOT)) {
            event.setCanceled(true);
        } else if (event.getLightning().m_19880_().contains(event.getEntity().m_20149_())) {
            event.setCanceled(true);
        }
    }
}

