/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio;

import artifacts.client.render.curio.model.ArmsModel;
import artifacts.client.render.curio.model.BeltModel;
import artifacts.client.render.curio.model.HeadModel;
import artifacts.client.render.curio.model.LegsModel;
import artifacts.client.render.curio.model.NecklaceModel;
import artifacts.client.render.curio.model.ScarfModel;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.EntityRenderersEvent;

public class CurioLayers {
    public static final ModelLayerLocation DRINKING_HAT = CurioLayers.createLayerLocation("drinking_hat");
    public static final ModelLayerLocation SNORKEL = CurioLayers.createLayerLocation("snorkel");
    public static final ModelLayerLocation NIGHT_VISION_GOGGLES = CurioLayers.createLayerLocation("night_vision_goggles");
    public static final ModelLayerLocation SUPERSTITIOUS_HAT = CurioLayers.createLayerLocation("superstitious_hat");
    public static final ModelLayerLocation VILLAGER_HAT = CurioLayers.createLayerLocation("villager_hat");
    public static final ModelLayerLocation SCARF = CurioLayers.createLayerLocation("scarf");
    public static final ModelLayerLocation CROSS_NECKLACE = CurioLayers.createLayerLocation("cross_necklace");
    public static final ModelLayerLocation PANIC_NECKLACE = CurioLayers.createLayerLocation("panic_necklace");
    public static final ModelLayerLocation PENDANT = CurioLayers.createLayerLocation("pendant");
    public static final ModelLayerLocation CHARM_OF_SINKING = CurioLayers.createLayerLocation("charm_of_sinking");
    public static final ModelLayerLocation CLOUD_IN_A_BOTTLE = CurioLayers.createLayerLocation("cloud_in_a_bottle");
    public static final ModelLayerLocation OBSIDIAN_SKULL = CurioLayers.createLayerLocation("obsidian_skull");
    public static final ModelLayerLocation ANTIDOTE_VESSEL = CurioLayers.createLayerLocation("antidote_vessel");
    public static final ModelLayerLocation UNIVERSAL_ATTRACTOR = CurioLayers.createLayerLocation("universal_attractor");
    public static final ModelLayerLocation CRYSTAL_HEART = CurioLayers.createLayerLocation("crystal_heart");
    public static final ModelLayerLocation HELIUM_FLAMINGO = CurioLayers.createLayerLocation("helium_flamingo");
    public static final ModelLayerLocation CLAWS = CurioLayers.createLayerLocation("claws");
    public static final ModelLayerLocation SLIM_CLAWS = CurioLayers.createLayerLocation("slim_claws");
    public static final ModelLayerLocation GLOVE = CurioLayers.createLayerLocation("gloves");
    public static final ModelLayerLocation SLIM_GLOVE = CurioLayers.createLayerLocation("slim_gloves");
    public static final ModelLayerLocation GOLDEN_HOOK = CurioLayers.createLayerLocation("golden_hook");
    public static final ModelLayerLocation SLIM_GOLDEN_HOOK = CurioLayers.createLayerLocation("slim_golden_hook");
    public static final ModelLayerLocation AQUA_DASHERS = CurioLayers.createLayerLocation("aqua_dashers");
    public static final ModelLayerLocation BUNNY_HOPPERS = CurioLayers.createLayerLocation("bunny_hoppers");
    public static final ModelLayerLocation KITTY_SLIPPERS = CurioLayers.createLayerLocation("kitty_slippers");
    public static final ModelLayerLocation RUNNING_SHOES = CurioLayers.createLayerLocation("running_shoes");
    public static final ModelLayerLocation STEADFAST_SPIKES = CurioLayers.createLayerLocation("steadfast_spikes");
    public static final ModelLayerLocation FLIPPERS = CurioLayers.createLayerLocation("flippers");
    public static final ModelLayerLocation WHOOPEE_CUSHION = CurioLayers.createLayerLocation("whoopee_cushion");

    public static ModelLayerLocation claws(boolean smallArms) {
        return smallArms ? SLIM_CLAWS : CLAWS;
    }

    public static ModelLayerLocation glove(boolean smallArms) {
        return smallArms ? SLIM_GLOVE : GLOVE;
    }

    public static ModelLayerLocation goldenHook(boolean smallArms) {
        return smallArms ? SLIM_GOLDEN_HOOK : GOLDEN_HOOK;
    }

    public static ModelLayerLocation createLayerLocation(String name) {
        return new ModelLayerLocation(new ResourceLocation("artifacts", name), name);
    }

    private static Supplier<LayerDefinition> layer(MeshDefinition mesh, int textureWidth, int textureHeight) {
        return () -> LayerDefinition.m_171565_((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    private static void register(EntityRenderersEvent.RegisterLayerDefinitions event, ModelLayerLocation layerLocation, Supplier<LayerDefinition> layer) {
        event.registerLayerDefinition(layerLocation, layer);
    }

    public static void register(EntityRenderersEvent.RegisterLayerDefinitions event) {
        CurioLayers.register(event, DRINKING_HAT, CurioLayers.layer(HeadModel.createDrinkingHat(), 64, 32));
        CurioLayers.register(event, SNORKEL, CurioLayers.layer(HeadModel.createSnorkel(), 64, 32));
        CurioLayers.register(event, NIGHT_VISION_GOGGLES, CurioLayers.layer(HeadModel.createNightVisionGoggles(), 32, 32));
        CurioLayers.register(event, SUPERSTITIOUS_HAT, CurioLayers.layer(HeadModel.createSuperstitiousHat(), 64, 32));
        CurioLayers.register(event, VILLAGER_HAT, CurioLayers.layer(HeadModel.createVillagerHat(), 32, 32));
        CurioLayers.register(event, SCARF, CurioLayers.layer(ScarfModel.createScarf(), 64, 32));
        CurioLayers.register(event, CROSS_NECKLACE, CurioLayers.layer(NecklaceModel.createCrossNecklace(), 64, 48));
        CurioLayers.register(event, PANIC_NECKLACE, CurioLayers.layer(NecklaceModel.createPanicNecklace(), 64, 48));
        CurioLayers.register(event, PENDANT, CurioLayers.layer(NecklaceModel.createPendant(), 64, 48));
        CurioLayers.register(event, CHARM_OF_SINKING, CurioLayers.layer(NecklaceModel.createCharmOfSinking(), 64, 48));
        CurioLayers.register(event, CLOUD_IN_A_BOTTLE, CurioLayers.layer(BeltModel.createCloudInABottle(), 32, 32));
        CurioLayers.register(event, OBSIDIAN_SKULL, CurioLayers.layer(BeltModel.createObsidianSkull(), 32, 32));
        CurioLayers.register(event, ANTIDOTE_VESSEL, CurioLayers.layer(BeltModel.createAntidoteVessel(), 32, 32));
        CurioLayers.register(event, UNIVERSAL_ATTRACTOR, CurioLayers.layer(BeltModel.createUniversalAttractor(), 32, 32));
        CurioLayers.register(event, CRYSTAL_HEART, CurioLayers.layer(BeltModel.createCrystalHeart(), 32, 32));
        CurioLayers.register(event, HELIUM_FLAMINGO, CurioLayers.layer(BeltModel.createHeliumFlamingo(), 64, 64));
        CurioLayers.register(event, CLAWS, CurioLayers.layer(ArmsModel.createClaws(false), 32, 16));
        CurioLayers.register(event, SLIM_CLAWS, CurioLayers.layer(ArmsModel.createClaws(true), 32, 16));
        CurioLayers.register(event, GLOVE, CurioLayers.layer(ArmsModel.createSleevedArms(false), 32, 32));
        CurioLayers.register(event, SLIM_GLOVE, CurioLayers.layer(ArmsModel.createSleevedArms(true), 32, 32));
        CurioLayers.register(event, GOLDEN_HOOK, CurioLayers.layer(ArmsModel.createGoldenHook(false), 64, 32));
        CurioLayers.register(event, SLIM_GOLDEN_HOOK, CurioLayers.layer(ArmsModel.createGoldenHook(true), 64, 32));
        CurioLayers.register(event, AQUA_DASHERS, CurioLayers.layer(LegsModel.createAquaDashers(), 32, 32));
        CurioLayers.register(event, BUNNY_HOPPERS, CurioLayers.layer(LegsModel.createBunnyHoppers(), 64, 32));
        CurioLayers.register(event, KITTY_SLIPPERS, CurioLayers.layer(LegsModel.createKittySlippers(), 64, 32));
        CurioLayers.register(event, RUNNING_SHOES, CurioLayers.layer(LegsModel.createRunningShoes(), 32, 32));
        CurioLayers.register(event, STEADFAST_SPIKES, CurioLayers.layer(LegsModel.createSteadfastSpikes(), 64, 32));
        CurioLayers.register(event, FLIPPERS, CurioLayers.layer(LegsModel.createFlippers(), 64, 64));
        CurioLayers.register(event, WHOOPEE_CUSHION, CurioLayers.layer(HeadModel.createWhoopeeCushion(), 32, 16));
    }
}

