/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.cells.StorageCell;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.me.storage.DelegatingMEInventory;
import appeng.me.storage.DriveWatcher;
import gripe._90.megacells.crafting.DecompressionPattern;
import gripe._90.megacells.crafting.DecompressionPatternEncoding;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.item.cell.BulkCellInventory;
import gripe._90.megacells.item.part.DecompressionModulePart;
import gripe._90.megacells.util.CompressionChain;
import gripe._90.megacells.util.CompressionVariant;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;

public class DecompressionService
implements IGridService,
IGridServiceProvider {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Class<?> CHEST_MONITOR_CLASS;
    private static final VarHandle CHEST_MONITOR_HANDLE;
    private static final VarHandle CHEST_CELL_HANDLE;
    private static final MethodHandle DRIVE_DELEGATE_HANDLE;
    private static final VarHandle DRIVE_WATCHERS_HANDLE;
    private final List<ChestBlockEntity> chests = new ObjectArrayList();
    private final List<DriveBlockEntity> drives = new ObjectArrayList();
    private final List<IPatternDetails> patterns = new ObjectArrayList();
    private final List<DecompressionModulePart> modules = new ObjectArrayList();

    public void addNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)object;
            this.chests.add(chest);
        }
        if ((object = node.getOwner()) instanceof DriveBlockEntity) {
            DriveBlockEntity drive = (DriveBlockEntity)object;
            this.drives.add(drive);
        }
        if ((object = node.getOwner()) instanceof DecompressionModulePart) {
            DecompressionModulePart module = (DecompressionModulePart)((Object)object);
            this.modules.add(module);
        }
    }

    public void removeNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)object;
            this.chests.remove(chest);
        }
        if ((object = node.getOwner()) instanceof DriveBlockEntity) {
            DriveBlockEntity drive = (DriveBlockEntity)object;
            this.drives.remove(drive);
        }
        if ((object = node.getOwner()) instanceof DecompressionModulePart) {
            DecompressionModulePart module = (DecompressionModulePart)((Object)object);
            this.modules.remove((Object)module);
        }
    }

    public void onServerStartTick() {
        this.patterns.clear();
        for (ChestBlockEntity chest : this.chests) {
            BulkCellInventory bulkCell;
            StorageCell cell = this.getCellByChest(chest);
            if (!(cell instanceof BulkCellInventory) || !(bulkCell = (BulkCellInventory)cell).isCompressionEnabled()) continue;
            this.patterns.addAll(this.generatePatterns(bulkCell));
        }
        for (DriveBlockEntity drive : this.drives) {
            for (int i = 0; i < drive.getCellCount(); ++i) {
                try {
                    BulkCellInventory bulkCell;
                    StorageCell cell = this.getCellByDriveSlot(drive, i);
                    if (!(cell instanceof BulkCellInventory) || !(bulkCell = (BulkCellInventory)cell).isCompressionEnabled()) continue;
                    this.patterns.addAll(this.generatePatterns(bulkCell));
                    continue;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
        for (DecompressionModulePart module : this.modules) {
            ICraftingProvider.requestUpdate((IManagedGridNode)module.getMainNode());
        }
    }

    private StorageCell getCellByChest(ChestBlockEntity chest) {
        Object monitor = CHEST_MONITOR_HANDLE.get(chest);
        return monitor != null ? CHEST_CELL_HANDLE.get(monitor) : null;
    }

    private StorageCell getCellByDriveSlot(DriveBlockEntity drive, int slot) throws Throwable {
        DriveWatcher[] watchers = DRIVE_WATCHERS_HANDLE.get(drive);
        return watchers[slot] != null ? DRIVE_DELEGATE_HANDLE.invoke(watchers[slot]) : null;
    }

    public List<IPatternDetails> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    private Set<IPatternDetails> generatePatterns(BulkCellInventory cell) {
        CompressionChain fullChain = cell.getCompressionChain();
        if (fullChain.isEmpty()) {
            return Set.of();
        }
        ObjectLinkedOpenHashSet patterns = new ObjectLinkedOpenHashSet();
        CompressionChain decompressionChain = fullChain.reversed();
        ObjectListIterator objectListIterator = decompressionChain.iterator();
        while (objectListIterator.hasNext()) {
            CompressionVariant variant = (CompressionVariant)objectListIterator.next();
            if (variant == decompressionChain.last()) continue;
            ItemStack pattern = new ItemStack(MEGAItems.DECOMPRESSION_PATTERN);
            CompressionVariant decompressed = (CompressionVariant)decompressionChain.get(decompressionChain.indexOf(variant) + 1);
            DecompressionPatternEncoding.encode(pattern.m_41784_(), decompressed.item(), variant, false);
            patterns.add((Object)new DecompressionPattern(pattern));
        }
        ObjectList compressionChain = fullChain.subList(decompressionChain.size() - 1, fullChain.size());
        for (CompressionVariant variant : compressionChain) {
            if (variant == compressionChain.get(0)) continue;
            ItemStack pattern = new ItemStack(MEGAItems.DECOMPRESSION_PATTERN);
            CompressionVariant decompressed = (CompressionVariant)compressionChain.get(compressionChain.indexOf((Object)variant) - 1);
            DecompressionPatternEncoding.encode(pattern.m_41784_(), decompressed.item(), variant, true);
            patterns.add((Object)new DecompressionPattern(pattern));
        }
        return patterns;
    }

    static {
        try {
            CHEST_MONITOR_CLASS = Class.forName("appeng.blockentity.storage.ChestBlockEntity$ChestMonitorHandler");
            CHEST_MONITOR_HANDLE = MethodHandles.privateLookupIn(ChestBlockEntity.class, LOOKUP).findVarHandle(ChestBlockEntity.class, "cellHandler", CHEST_MONITOR_CLASS);
            CHEST_CELL_HANDLE = MethodHandles.privateLookupIn(CHEST_MONITOR_CLASS, LOOKUP).findVarHandle(CHEST_MONITOR_CLASS, "cellInventory", StorageCell.class);
            DRIVE_WATCHERS_HANDLE = MethodHandles.privateLookupIn(DriveBlockEntity.class, LOOKUP).findVarHandle(DriveBlockEntity.class, "invBySlot", DriveWatcher[].class);
            DRIVE_DELEGATE_HANDLE = MethodHandles.privateLookupIn(DelegatingMEInventory.class, LOOKUP).findVirtual(DelegatingMEInventory.class, "getDelegate", MethodType.methodType(MEStorage.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to create DecompressionService method handles", e);
        }
    }
}

