/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.forge;

import appeng.api.networking.GridServices;
import appeng.core.AppEng;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGAPatternProviderBlock;
import gripe._90.megacells.core.Addons;
import gripe._90.megacells.crafting.DecompressionService;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAParts;
import gripe._90.megacells.forge.MEGACellsClient;
import gripe._90.megacells.init.InitStorageCells;
import gripe._90.megacells.init.InitUpgrades;
import gripe._90.megacells.integration.appbot.AppBotItems;
import gripe._90.megacells.integration.appmek.AppMekIntegration;
import gripe._90.megacells.integration.appmek.AppMekItems;
import gripe._90.megacells.util.CompressionService;
import net.minecraft.core.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="megacells")
public class MEGACellsForge {
    public MEGACellsForge() {
        this.initAll();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerAll);
        bus.addListener(this::initCells);
        this.initCompression();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> MEGACellsClient::new);
    }

    private void initAll() {
        MEGABlocks.init();
        MEGAItems.init();
        MEGAParts.init();
        MEGABlockEntities.init();
        if (MEGACells.PLATFORM.isAddonLoaded(Addons.APPMEK)) {
            AppMekItems.init();
        }
        if (MEGACells.PLATFORM.isAddonLoaded(Addons.APPBOT)) {
            AppBotItems.init();
        }
    }

    private void registerAll(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registry.f_122901_)) {
            MEGABlocks.getBlocks().forEach(b -> {
                ForgeRegistries.BLOCKS.register(b.id(), (Object)b.block());
                ForgeRegistries.ITEMS.register(b.id(), (Object)b.m_5456_());
            });
        }
        if (event.getRegistryKey().equals((Object)Registry.f_122904_)) {
            MEGAItems.getItems().forEach(i -> ForgeRegistries.ITEMS.register(i.id(), (Object)i.m_5456_()));
        }
        if (event.getRegistryKey().equals((Object)Registry.f_122907_)) {
            MEGABlockEntities.getBlockEntityTypes().forEach((arg_0, arg_1) -> ((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).register(arg_0, arg_1));
        }
        if (event.getRegistryKey().equals((Object)Registry.f_122913_)) {
            ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"mega_pattern_provider"), MEGAPatternProviderBlock.MENU);
        }
    }

    private void initCells(FMLCommonSetupEvent event) {
        event.enqueueWork(InitStorageCells::init);
        event.enqueueWork(InitUpgrades::init);
        event.enqueueWork(() -> {
            if (MEGACells.PLATFORM.isAddonLoaded(Addons.APPMEK)) {
                AppMekIntegration.initUpgrades();
                AppMekIntegration.initStorageCells();
            }
        });
    }

    private void initCompression() {
        MinecraftForge.EVENT_BUS.addListener(event -> CompressionService.INSTANCE.loadRecipes(event.getServer().m_129894_()));
        MinecraftForge.EVENT_BUS.addListener(event -> CompressionService.INSTANCE.loadRecipes(event.getServerResources().m_206887_()));
        GridServices.register(DecompressionService.class, DecompressionService.class);
    }
}

