/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.util;

import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGATags;
import gripe._90.megacells.util.CompressionChain;
import gripe._90.megacells.util.CompressionVariant;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class CompressionService {
    public static final CompressionService INSTANCE = new CompressionService();
    private final Set<CompressionChain> compressionChains = new ObjectLinkedOpenHashSet();
    private final Set<Override> overrides = new ObjectLinkedOpenHashSet();

    private CompressionService() {
    }

    public Optional<CompressionChain> getChain(AEItemKey item) {
        return this.compressionChains.stream().filter(chain -> chain.containsVariant(item)).findFirst();
    }

    public void loadRecipes(RecipeManager recipeManager) {
        this.compressionChains.clear();
        this.overrides.clear();
        List allRecipes = recipeManager.m_44013_(RecipeType.f_44107_);
        List<CraftingRecipe> compressedCandidates = allRecipes.stream().filter(this::isCompressionRecipe).toList();
        List<CraftingRecipe> decompressedCandidates = allRecipes.stream().filter(this::isDecompressionRecipe).toList();
        List<CraftingRecipe> compressed = compressedCandidates.stream().filter(recipe -> this.isReversibleRecipe((CraftingRecipe)recipe, decompressedCandidates)).toList();
        List<CraftingRecipe> decompressed = decompressedCandidates.stream().filter(recipe -> this.isReversibleRecipe((CraftingRecipe)recipe, compressedCandidates)).toList();
        Stream.concat(compressed.stream(), decompressed.stream()).forEach(recipe -> {
            Item baseVariant = recipe.m_8043_().m_41720_();
            if (this.compressionChains.stream().noneMatch(chain -> chain.containsVariant(AEItemKey.of((ItemLike)baseVariant)))) {
                this.compressionChains.add(this.generateChain(baseVariant, compressed, decompressed));
            }
        });
        if (!this.compressionChains.isEmpty()) {
            MEGACells.LOGGER.info("(Re-)initialised bulk cell compression.");
        }
    }

    private CompressionChain generateChain(Item baseVariant, List<CraftingRecipe> compressed, List<CraftingRecipe> decompressed) {
        LinkedList<Item> variants = new LinkedList<Item>();
        LinkedList<Integer> multipliers = new LinkedList<Integer>();
        variants.addFirst(baseVariant);
        CompressionVariant lower = this.getNextVariant(baseVariant, decompressed, false);
        while (lower != null) {
            variants.addFirst(lower.item().getItem());
            multipliers.addFirst(lower.factor());
            lower = this.getNextVariant(lower.item().getItem(), decompressed, false);
        }
        multipliers.addFirst(1);
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < variants.size(); ++i) {
            chain.add(AEItemKey.of((ItemLike)((ItemLike)variants.get(i))), (Integer)multipliers.get(i));
        }
        CompressionVariant higher = this.getNextVariant(baseVariant, compressed, true);
        while (higher != null) {
            chain.add(higher);
            higher = this.getNextVariant(higher.item().getItem(), compressed, true);
        }
        return chain;
    }

    private CompressionVariant getNextVariant(Item item, List<CraftingRecipe> recipes, boolean compressed) {
        for (Override override : this.overrides) {
            if (compressed && override.smaller.equals(item)) {
                return new CompressionVariant(override.larger, override.factor);
            }
            if (compressed || !override.larger.equals(item)) continue;
            return new CompressionVariant(override.smaller, override.factor);
        }
        for (CraftingRecipe recipe : recipes) {
            for (ItemStack input : ((Ingredient)recipe.m_7527_().get(0)).m_43908_()) {
                if (!input.m_41720_().equals(item)) continue;
                return new CompressionVariant(recipe.m_8043_().m_41720_(), compressed ? recipe.m_7527_().size() : recipe.m_8043_().m_41613_());
            }
        }
        return null;
    }

    private boolean isDecompressionRecipe(CraftingRecipe recipe) {
        return recipe.m_7527_().stream().filter(i -> !i.m_43947_()).count() == 1L && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(recipe.m_8043_().m_41613_());
    }

    private boolean isCompressionRecipe(CraftingRecipe recipe) {
        NonNullList ingredients = recipe.m_7527_();
        return recipe.m_8043_().m_41613_() == 1 && ingredients.stream().noneMatch(Ingredient::m_43947_) && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(ingredients.size()) && this.sameIngredient((List<Ingredient>)ingredients);
    }

    private boolean sameIngredient(List<Ingredient> ingredients) {
        if (ingredients.stream().distinct().count() <= 1L) {
            return true;
        }
        ItemStack[] first = ingredients.get(0).m_43908_();
        for (Ingredient ingredient : ingredients) {
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length != first.length) {
                return false;
            }
            for (int i = 0; i < stacks.length; ++i) {
                if (ItemStack.m_150942_((ItemStack)stacks[i], (ItemStack)first[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isReversibleRecipe(CraftingRecipe recipe, List<CraftingRecipe> candidates) {
        if (this.overrideRecipe(recipe)) {
            return true;
        }
        boolean compressible = false;
        boolean decompressible = false;
        Ingredient input = (Ingredient)recipe.m_7527_().get(0);
        ItemStack output = recipe.m_8043_();
        for (CraftingRecipe candidate : candidates) {
            for (ItemStack item : ((Ingredient)candidate.m_7527_().get(0)).m_43908_()) {
                if (!item.m_41720_().equals(output.m_41720_())) continue;
                compressible = true;
            }
            for (ItemStack item : input.m_43908_()) {
                if (!item.m_41720_().equals(candidate.m_8043_().m_41720_())) continue;
                decompressible = true;
            }
            if (!compressible || !decompressible) continue;
            return true;
        }
        return false;
    }

    private boolean overrideRecipe(CraftingRecipe recipe) {
        for (ItemStack input : ((Ingredient)recipe.m_7527_().get(0)).m_43908_()) {
            if (!input.m_204117_(MEGATags.COMPRESSION_OVERRIDES)) continue;
            boolean compressed = !this.isDecompressionRecipe(recipe);
            ItemStack output = recipe.m_8043_();
            Item smaller = compressed ? input.m_41720_() : output.m_41720_();
            Item larger = compressed ? output.m_41720_() : input.m_41720_();
            int factor = compressed ? recipe.m_7527_().size() : output.m_41613_();
            this.overrides.add(new Override(smaller, larger, compressed, factor));
            return true;
        }
        return false;
    }

    private record Override(Item smaller, Item larger, boolean compressed, int factor) {
    }
}

