/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.FinishedJobToast;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.sync.packets.CraftingJobStatusPacket;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.util.SearchInventoryEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class PendingCraftingJobs {
    private static final Map<String, PendingJob> jobs = new HashMap<String, PendingJob>();

    private PendingCraftingJobs() {
    }

    public static boolean hasPendingJob(AEKey what) {
        return jobs.entrySet().stream().anyMatch(s -> ((PendingJob)s.getValue()).what.equals(what));
    }

    public static void clearPendingJobs() {
        jobs.clear();
    }

    public static void jobStatus(String id, AEKey what, long requestedAmount, long remainingAmount, CraftingJobStatusPacket.Status status) {
        AELog.debug("Crafting job " + id + " for " + requestedAmount + "x" + AEStackRendering.getDisplayName(what).getString() + ". State=" + status, new Object[0]);
        PendingJob existing = jobs.get(id);
        switch (status) {
            case STARTED: {
                if (existing != null) break;
                jobs.put(id, new PendingJob(id, what, requestedAmount, remainingAmount));
                break;
            }
            case CANCELLED: {
                jobs.remove(id);
                break;
            }
            case FINISHED: {
                jobs.remove(id);
                Minecraft minecraft = Minecraft.m_91087_();
                if (!AEConfig.instance().isNotifyForFinishedCraftingJobs() || minecraft.f_91080_ instanceof MEStorageScreen || minecraft.f_91074_ == null || !PendingCraftingJobs.hasNotificationEnablingItem(minecraft.f_91074_)) break;
                minecraft.m_91300_().m_94922_((Toast)new FinishedJobToast(what, requestedAmount));
            }
        }
    }

    private static boolean hasNotificationEnablingItem(LocalPlayer player) {
        for (ItemStack stack : SearchInventoryEvent.getItems((Player)player)) {
            WirelessTerminalItem wirelessTerminal;
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof WirelessTerminalItem) || !((wirelessTerminal = (WirelessTerminalItem)item).getAECurrentPower(stack) > 0.0) || !wirelessTerminal.getGridKey(stack).isPresent()) continue;
            return true;
        }
        return false;
    }

    record PendingJob(String jobId, AEKey what, long requestedAmount, long remainingAmount) {
    }
}

