/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.client.StorageCellModels;
import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.model.DriveBakedModel;
import appeng.init.internal.InitStorageCells;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class DriveModel
implements BasicUnbakedModel<DriveModel> {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("ae2:block/drive/drive_base");
    private static final ResourceLocation MODEL_CELL_EMPTY = new ResourceLocation("ae2:block/drive/drive_cell_empty");

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        IdentityHashMap<Item, BakedModel> cellModels = new IdentityHashMap<Item, BakedModel>();
        for (Map.Entry<Item, ResourceLocation> entry : StorageCellModels.models().entrySet()) {
            BakedModel cellModel = bakery.bake(entry.getValue(), modelTransform, spriteGetter);
            cellModels.put(entry.getKey(), cellModel);
        }
        BakedModel baseModel = bakery.bake(MODEL_BASE, modelTransform, spriteGetter);
        BakedModel defaultCell = bakery.bake(StorageCellModels.getDefaultModel(), modelTransform, spriteGetter);
        cellModels.put(Items.f_41852_, bakery.bake(MODEL_CELL_EMPTY, modelTransform, spriteGetter));
        return new DriveBakedModel(baseModel, cellModels, defaultCell);
    }

    @Override
    public Collection<ResourceLocation> getModelDependencies() {
        return ImmutableSet.builder().add((Object)StorageCellModels.getDefaultModel()).addAll(InitStorageCells.getModels()).addAll(StorageCellModels.models().values()).build();
    }
}

