/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin;

import ic2.core.block.base.features.multiblock.IStructureListener;
import ic2.core.block.cables.CableBlock;
import ic2.core.block.crops.CropBlock;
import ic2.core.block.crops.CropTileEntity;
import ic2.core.block.misc.BarrelBlock;
import ic2.core.block.misc.TreeTapAndBucketBlock;
import ic2.core.block.misc.tiles.BarrelTileEntity;
import ic2.core.block.storage.tiles.tank.BaseValveTileEntity;
import ic2.core.platform.events.StructureManager;
import ic2.jadeplugin.JadeTags;
import ic2.jadeplugin.base.JadeTooltipRenderer;
import ic2.jadeplugin.base.removals.JadeTankInfoRenderer;
import ic2.jadeplugin.base.removals.ModNameRender;
import ic2.jadeplugin.providers.BarrelInfo;
import ic2.jadeplugin.providers.CableInfo;
import ic2.jadeplugin.providers.CropInfo;
import ic2.jadeplugin.providers.TexturedBlockInfo;
import ic2.jadeplugin.providers.TreetapAndBucketInfo;
import ic2.jadeplugin.providers.WrenchInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;

@WailaPlugin(value="ic2")
public class IC2JadePluginHandler
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(JadeTags.TOP_STYLE, true);
        registration.registerBlockIcon((IBlockComponentProvider)new BarrelInfo.BarrelIconProvider(), BarrelBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)CropInfo.CropIcon.THIS, CropBlock.class);
        registration.registerBlockIcon((IBlockComponentProvider)CropInfo.CropIcon.THIS, CropBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)JadeTooltipRenderer.INSTANCE, Block.class);
        registration.registerBlockComponent((IBlockComponentProvider)new CableInfo.CableIconProvider(), CableBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)TexturedBlockInfo.INSTANCE, Block.class);
        registration.registerBlockIcon((IBlockComponentProvider)TexturedBlockInfo.INSTANCE, Block.class);
        registration.addRayTraceCallback((hitResult, accessor, originalAccessor) -> {
            if (accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                Level level = blockAccessor.getLevel();
                BlockPos pos = blockAccessor.getPosition();
                BlockHitResult blockHitResult = (BlockHitResult)blockAccessor.getHitResult();
                IStructureListener listener = StructureManager.INSTANCE.getListener(level, pos);
                if (listener instanceof BlockEntity) {
                    BlockEntity master = (BlockEntity)listener;
                    if (!(blockAccessor.getBlockEntity() instanceof BaseValveTileEntity)) {
                        CompoundTag structureTag = new CompoundTag();
                        blockAccessor.getServerData().m_128365_("Structure", (Tag)structureTag);
                        return registration.blockAccessor().from(blockAccessor).hit(blockHitResult.m_82430_(master.m_58899_())).blockState(level.m_8055_(master.m_58899_())).blockEntity(master).build();
                    }
                }
            }
            return accessor;
        });
        registration.registerBlockComponent((IBlockComponentProvider)JadeTankInfoRenderer.INSTANCE, Block.class);
        registration.registerBlockComponent((IBlockComponentProvider)TreetapAndBucketInfo.THIS, TreeTapAndBucketBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)ModNameRender.MOD_NAME_REMOVER, Block.class);
        registration.registerBlockComponent((IBlockComponentProvider)ModNameRender.MOD_NAME_RELOCATOR, Block.class);
        registration.registerBlockComponent((IBlockComponentProvider)WrenchInfo.THIS, Block.class);
    }

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)new BarrelInfo.BarrelIconProvider(), BarrelTileEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)JadeTooltipRenderer.INSTANCE, BlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)JadeTankInfoRenderer.INSTANCE, BlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)CropInfo.CropIcon.THIS, CropTileEntity.class);
    }
}

