/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.base.tiles.impls.BaseGeneratorTileEntity;
import ic2.core.block.generators.tiles.FuelGenTileEntity;
import ic2.core.block.generators.tiles.GeoGenTileEntity;
import ic2.core.block.generators.tiles.LiquidFuelGenTileEntity;
import ic2.core.block.generators.tiles.SlagGenTileEntity;
import ic2.core.block.generators.tiles.SolarTurbineTileEntity;
import ic2.core.block.generators.tiles.ThermalGeneratorTileEntity;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.Formatter;
import ic2.jadeplugin.helpers.TextFormatter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BaseGeneratorInfo
implements IInfoProvider {
    public static final BaseGeneratorInfo THIS = new BaseGeneratorInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof BaseGeneratorTileEntity) {
            BaseGeneratorTileEntity gen = (BaseGeneratorTileEntity)blockEntity;
            float euProduction = gen.getEUProduction();
            helper.tier(gen.getSourceTier());
            helper.defaultText("ic2.probe.eu.output.current.name", TextFormatter.GREEN.literal(Formatter.formatNumber(euProduction, 3)));
            helper.maxOut(gen.getMaxEnergyOutput());
            if (gen instanceof SolarTurbineTileEntity) {
                SolarTurbineTileEntity solarTurbine = (SolarTurbineTileEntity)gen;
                int heat = solarTurbine.getHeat();
                int maxHeat = solarTurbine.getMaxHeat();
                helper.bar(heat, maxHeat, (Component)this.translate("ic2.probe.heat.name", new Object[]{Formatter.THERMAL_GEN.format((float)heat / 240.0f)}), -295680);
            }
            if (gen instanceof ThermalGeneratorTileEntity) {
                ThermalGeneratorTileEntity thermal = (ThermalGeneratorTileEntity)gen;
                float subProduction = thermal.subProduction.getProduction(2000.0f);
                helper.text((Component)this.translate("ic2.probe.production.passive.name", new Object[]{TextFormatter.GREEN.literal(Formatter.THERMAL_GEN.format(subProduction))}));
            }
            if (gen instanceof SolarTurbineTileEntity || gen instanceof ThermalGeneratorTileEntity || gen instanceof GeoGenTileEntity || gen instanceof LiquidFuelGenTileEntity) {
                helper.addTankInfo((BlockEntity)gen);
            }
            int fuel = gen.getFuel();
            int maxFuel = gen.getMaxFuel();
            if ((gen instanceof SlagGenTileEntity || gen instanceof FuelGenTileEntity) && fuel > 0) {
                helper.bar(fuel, maxFuel, (Component)this.translate("ic2.probe.fuel.storage.name").m_130946_(String.valueOf(fuel)), ColorUtils.DARK_GRAY);
            }
        }
    }
}

