/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.base.tiles.impls.machine.single.BaseAdvMachineTileEntity;
import ic2.core.block.base.tiles.impls.machine.single.BaseMachineTileEntity;
import ic2.core.block.machines.tiles.lv.RareEarthExtractorTileEntity;
import ic2.core.block.machines.tiles.mv.RareEarthCentrifugeTileEntity;
import ic2.core.block.machines.tiles.mv.RefineryTileEntity;
import ic2.core.block.machines.tiles.mv.SlowGrinderTileEntity;
import ic2.core.block.machines.tiles.mv.VacuumCannerTileEntity;
import ic2.core.utils.helpers.Formatters;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.TextFormatter;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BaseMachineInfo
implements IInfoProvider {
    public static final BaseMachineInfo THIS = new BaseMachineInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof BaseMachineTileEntity) {
            double scaledProgress;
            Component speedName;
            BaseMachineTileEntity baseMachine = (BaseMachineTileEntity)blockEntity;
            helper.maxIn(baseMachine.getMaxInput());
            helper.usage(baseMachine.getEnergyPerTick());
            if (baseMachine instanceof SlowGrinderTileEntity) {
                SlowGrinderTileEntity slowGrinder = (SlowGrinderTileEntity)baseMachine;
                double chance = slowGrinder.getChance(0.25f) * 100.0f;
                helper.defaultText("ic2.probe.scrap.chance.name", TextFormatter.formatPercentage((int)chance).literal(Formatters.XP_FORMAT.format(chance)));
            }
            if (baseMachine instanceof RefineryTileEntity) {
                RefineryTileEntity refinery = (RefineryTileEntity)baseMachine;
                helper.addTankInfo((BlockEntity)refinery);
            }
            float progress = baseMachine.getProgress();
            float maxProgress = baseMachine.getMaxProgress();
            float progressPerTick = baseMachine.progressPerTick;
            if (baseMachine instanceof BaseAdvMachineTileEntity) {
                BaseAdvMachineTileEntity adv = (BaseAdvMachineTileEntity)baseMachine;
                int speed = adv.getSpeed();
                int maxSpeed = adv.getMaxSpeed();
                speedName = adv.getSpeedName();
                scaledProgress = (double)speed / (double)maxSpeed;
                if (speed > 0) {
                    helper.bar(speed, maxSpeed, (Component)speedName.m_6879_().m_130946_(": " + new DecimalFormat().format(scaledProgress * 100.0) + "%"), -295680);
                }
            }
            if (baseMachine instanceof VacuumCannerTileEntity) {
                VacuumCannerTileEntity canner = (VacuumCannerTileEntity)baseMachine;
                int speed = canner.getSpeed();
                int maxSpeed = canner.getMaxSpeed();
                speedName = canner.getSpeedName();
                scaledProgress = (double)speed / (double)maxSpeed;
                if (speed > 0) {
                    helper.bar(speed, maxSpeed, (Component)speedName.m_6879_().m_130946_(": " + new DecimalFormat().format(scaledProgress * 100.0) + "%"), -295680);
                }
            }
            if (baseMachine instanceof RareEarthExtractorTileEntity) {
                RareEarthExtractorTileEntity rareExtractor = (RareEarthExtractorTileEntity)baseMachine;
                int material = (int)rareExtractor.materialProgress;
                if (material > 0) {
                    helper.bar(material, 1000, (Component)this.translate("ic2.probe.progress.material.name", new Object[]{Formatters.EU_READER_FORMAT.format(material)}), -5829955);
                }
            } else if (baseMachine instanceof RareEarthCentrifugeTileEntity) {
                RareEarthCentrifugeTileEntity rareEarthCentrifuge = (RareEarthCentrifugeTileEntity)baseMachine;
                int material = (int)rareEarthCentrifuge.materialProgress;
                if (material > 0) {
                    helper.bar(material, 1000, (Component)this.translate("ic2.probe.progress.material.name", new Object[]{Formatters.EU_READER_FORMAT.format(material)}), -5829955);
                }
                int speed = rareEarthCentrifuge.getSpeed();
                int maxSpeed = rareEarthCentrifuge.getMaxSpeed();
                speedName = rareEarthCentrifuge.getSpeedName();
                scaledProgress = (double)speed / (double)maxSpeed;
                if (speed > 0) {
                    helper.bar(speed, maxSpeed, (Component)speedName.m_6879_().m_130946_(": " + new DecimalFormat().format(scaledProgress * 100.0) + "%"), -295680);
                }
            }
            if (progress > 0.0f) {
                int scaledOp = (int)Math.min(6.0E7f, progress / progressPerTick);
                int scaledMaxOp = (int)Math.min(6.0E7f, maxProgress / progressPerTick);
                helper.bar(scaledOp, scaledMaxOp, (Component)this.translate("ic2.probe.progress.full.name", new Object[]{scaledOp, scaledMaxOp}).m_130946_("t"), -16733185);
            }
        }
    }
}

