/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.base.tiles.BaseLinkingTileEntity;
import ic2.core.block.machines.tiles.luv.FusionReactorTileEntity;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ThermonuclearReactorInfo
implements IInfoProvider {
    public static final ThermonuclearReactorInfo THIS = new ThermonuclearReactorInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        BaseLinkingTileEntity linking;
        BlockEntity master;
        if (blockEntity instanceof FusionReactorTileEntity) {
            FusionReactorTileEntity reactor = (FusionReactorTileEntity)blockEntity;
            this.addReactorInfo(helper, reactor, player);
            if (!reactor.isValid || reactor.isDynamic()) {
                long time = reactor.clockTime(512);
                helper.bar((int)time, 512, (Component)this.translate("ic2.multiblock.reform.next", new Object[]{512L - time}), ColorUtils.GRAY);
            }
        }
        if (blockEntity instanceof BaseLinkingTileEntity && (master = (linking = (BaseLinkingTileEntity)blockEntity).getMaster()) instanceof FusionReactorTileEntity) {
            FusionReactorTileEntity reactor = (FusionReactorTileEntity)master;
            this.addReactorInfo(helper, reactor, player);
        }
    }

    public void addReactorInfo(JadeHelper helper, FusionReactorTileEntity reactor, Player player) {
        int material;
        if (PlayerHandler.getHandler((Player)player).hasThermometer()) {
            helper.bar(reactor.heat, 48000, (Component)this.translate("ic2.probe.reactor.heat.name", new Object[]{Formatters.EU_READER_FORMAT.format(reactor.heat), Formatters.EU_READER_FORMAT.format(48000.0)}), ThermonuclearReactorInfo.getBarColor(reactor.heat, 48000));
        }
        if ((material = reactor.material) > 0) {
            helper.bar(material, 10000, (Component)this.translate("ic2.progress.material.name", new Object[]{Formatters.EU_READER_FORMAT.format(material), Formatters.EU_READER_FORMAT.format(10000L)}), ColorUtils.GRAY);
        }
        helper.addTankInfo((BlockEntity)reactor);
    }

    public static int getBarColor(int heat, int maxHeat) {
        float value = (float)heat / (float)maxHeat;
        if ((double)value < 0.6) {
            return ColorUtils.BLUE;
        }
        if ((double)value < 0.8) {
            return -4441721;
        }
        return ColorUtils.RED;
    }
}

