/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type.inputtable;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.base.client.config.screen.CategoryScreen;
import vazkii.quark.base.client.config.screen.WidgetWrapper;
import vazkii.quark.base.client.config.screen.inputtable.IInputtableConfigType;
import vazkii.quark.base.client.config.screen.inputtable.RGBColorInputScreen;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.inputtable.AbstractInputtableType;

public class RGBColorConfig
extends AbstractInputtableType<RGBColorConfig> {
    @Config
    public double r;
    @Config
    public double g;
    @Config
    public double b;
    protected double dr;
    protected double dg;
    protected double db;
    protected int color;

    private RGBColorConfig(double r, double g, double b) {
        this(r, g, b, 1.0);
    }

    RGBColorConfig(double r, double g, double b, double a) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static RGBColorConfig forColor(double r, double g, double b) {
        RGBColorConfig config = new RGBColorConfig(r, g, b);
        config.color = config.calculateColor();
        config.dr = r;
        config.dg = g;
        config.db = b;
        return config;
    }

    public int getColor() {
        return this.color;
    }

    public double getElement(int idx) {
        return switch (idx) {
            case 0 -> this.r;
            case 1 -> this.g;
            case 2 -> this.b;
            case 3 -> this.getAlphaComponent();
            default -> 0.0;
        };
    }

    public void setElement(int idx, double c) {
        switch (idx) {
            case 0: {
                this.r = c;
                break;
            }
            case 1: {
                this.g = c;
                break;
            }
            case 2: {
                this.b = c;
                break;
            }
            case 3: {
                this.setAlphaComponent(c);
            }
        }
        this.color = this.calculateColor();
    }

    @Override
    public void inheritDefaults(RGBColorConfig target) {
        this.r = target.dr;
        this.g = target.dg;
        this.b = target.db;
        this.color = this.calculateColor();
    }

    @Override
    public void onReload(QuarkModule module, ConfigFlagManager flagManager) {
        super.onReload(module, flagManager);
        this.color = this.calculateColor();
    }

    int calculateColor() {
        int rComponent = RGBColorConfig.clamp(this.r * 255.0) << 16;
        int gComponent = RGBColorConfig.clamp(this.g * 255.0) << 8;
        int bComponent = RGBColorConfig.clamp(this.b * 255.0);
        int aComponent = RGBColorConfig.clamp(this.getAlphaComponent() * 255.0) << 24;
        return aComponent | bComponent | gComponent | rComponent;
    }

    double getAlphaComponent() {
        return 1.0;
    }

    void setAlphaComponent(double c) {
    }

    @Override
    public void inherit(RGBColorConfig other, boolean committing) {
        this.r = other.r;
        this.g = other.g;
        this.b = other.b;
        this.color = other.color;
        if (!committing) {
            this.dr = other.r;
            this.dg = other.g;
            this.db = other.b;
        }
    }

    @Override
    public RGBColorConfig copy() {
        RGBColorConfig newMatrix = new RGBColorConfig(this.r, this.g, this.b);
        newMatrix.inherit(this, false);
        return newMatrix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RGBColorConfig that = (RGBColorConfig)o;
        return Double.compare(that.r, this.r) == 0 && Double.compare(that.g, this.g) == 0 && Double.compare(that.b, this.b) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.r, this.g, this.b);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addWidgets(CategoryScreen parent, IConfigElement element, List<WidgetWrapper> widgets) {
        IInputtableConfigType.addPencil(parent, element, widgets, () -> new RGBColorInputScreen((Screen)parent, this, element, parent.category));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getSubtitle() {
        return String.format("[%.1f, %.1f, %.1f]", this.r, this.g, this.b);
    }

    private static int clamp(double val) {
        return RGBColorConfig.clamp((int)val);
    }

    private static int clamp(int val) {
        return Mth.m_14045_((int)val, (int)0, (int)255);
    }
}

