/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkSlabBlock;
import vazkii.quark.base.client.handler.RequiredModTooltipHandler;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.VerticalSlabBlock;

public class QuarkVerticalSlabBlock
extends VerticalSlabBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkVerticalSlabBlock(Block parent, QuarkModule module) {
        super(() -> parent, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent));
        RegistryHelper.registerBlock((Block)this, (String)IQuarkBlock.inherit(parent, (String s) -> s.replace("_slab", "_vertical_slab")));
        this.module = module;
        CreativeTabHandler.addTab(this, CreativeModeTab.f_40749_);
        if (module.category.isAddon()) {
            RequiredModTooltipHandler.map(this, module.category.requiredMod);
        }
        if (!(parent instanceof SlabBlock)) {
            throw new IllegalArgumentException("Can't rotate a non-slab block into a vertical slab.");
        }
        if (parent instanceof QuarkSlabBlock) {
            QuarkSlabBlock quarkSlab = (QuarkSlabBlock)parent;
            this.setCondition(quarkSlab.parent::isEnabled);
        }
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkVerticalSlabBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }
}

