/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.content.mobs.module.ToretoiseModule;

public class Toretoise
extends Animal {
    private static final TagKey<Block> BREAKS_TORETOISE_ORE = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "breaks_toretoise_ore"));
    public static final int ORE_TYPES = 5;
    public static final int ANGERY_TIME = 20;
    private static final String TAG_TAMED = "tamed";
    private static final String TAG_ORE = "oreType";
    private static final String TAG_EAT_COOLDOWN = "eatCooldown";
    private static final String TAG_ANGERY_TICKS = "angeryTicks";
    public int rideTime;
    private boolean isTamed;
    private int eatCooldown;
    public int angeryTicks;
    private Ingredient goodFood;
    private LivingEntity lastAggressor;
    private static final EntityDataAccessor<Integer> ORE_TYPE = SynchedEntityData.m_135353_(Toretoise.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Toretoise(EntityType<? extends Toretoise> type, Level world) {
        super(type, world);
        this.f_19793_ = 1.0f;
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ORE_TYPE, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.getGoodFood(), false));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private Ingredient getGoodFood() {
        if (this.goodFood == null) {
            this.computeGoodFood();
        }
        return this.goodFood;
    }

    private void computeGoodFood() {
        this.goodFood = Ingredient.m_43921_(ToretoiseModule.foods.stream().map(loc -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(loc))).filter(Objects::nonNull).map(ItemStack::new));
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor world, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType spawnType, SpawnGroupData spawnData, CompoundTag additionalData) {
        this.popOre(true);
        return spawnData;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_35506_() {
        return this.getOreType() == 0 && this.eatCooldown == 0;
    }

    @Nonnull
    public SoundEvent m_7866_(@Nonnull ItemStack itemStackIn) {
        return null;
    }

    protected AABB m_142242_() {
        AABB aabb = super.m_142242_();
        double rheight = this.getOreType() == 0 ? 0.0 : 0.4;
        return new AABB(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_ + rheight, aabb.f_82293_);
    }

    public void m_8119_() {
        Level x2;
        super.m_8119_();
        Entity riding = this.m_20202_();
        this.rideTime = riding != null ? ++this.rideTime : 0;
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
        }
        if (this.angeryTicks > 0 && this.m_6084_()) {
            --this.angeryTicks;
            if (this.m_20096_()) {
                int dangerRange = 3;
                double x2 = this.m_20185_() + (double)(this.m_20205_() / 2.0f);
                double y = this.m_20186_();
                double z = this.m_20189_() + (double)(this.m_20205_() / 2.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.angeryTicks == 3) {
                        this.m_5496_(QuarkSounds.ENTITY_TORETOISE_ANGRY, 1.0f, 0.2f);
                    } else if (this.angeryTicks == 0) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x2, y, z, 200, (double)dangerRange, 0.5, (double)dangerRange, 0.0);
                        this.m_146850_(GameEvent.f_223709_);
                    }
                }
                if (this.angeryTicks == 0) {
                    AABB hurtAabb = new AABB(x2 - (double)dangerRange, y - 1.0, z - (double)dangerRange, x2 + (double)dangerRange, y + 1.0, z + (double)dangerRange);
                    List hurtMeDaddy = this.f_19853_.m_6443_(LivingEntity.class, hurtAabb, e -> !(e instanceof Toretoise));
                    Toretoise aggressor = this.lastAggressor == null ? this : this.lastAggressor;
                    DamageSource damageSource = DamageSource.m_19370_((LivingEntity)aggressor);
                    for (LivingEntity e2 : hurtMeDaddy) {
                        DamageSource useSource = damageSource;
                        if (e2 == aggressor) {
                            useSource = DamageSource.m_19370_((LivingEntity)this);
                        }
                        e2.m_6469_(useSource, (float)(4 + this.f_19853_.m_46791_().ordinal()));
                    }
                }
            }
        }
        if ((x2 = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)x2;
            int ore = this.getOreType();
            if (ore != 0) {
                AABB ourBoundingBox = this.m_20191_();
                BlockPos min = new BlockPos((double)Math.round(ourBoundingBox.f_82288_), (double)Math.round(ourBoundingBox.f_82289_), (double)Math.round(ourBoundingBox.f_82290_));
                BlockPos max = new BlockPos((double)Math.round(ourBoundingBox.f_82291_), (double)Math.round(ourBoundingBox.f_82292_), (double)Math.round(ourBoundingBox.f_82293_));
                block1: for (int ix = min.m_123341_(); ix <= max.m_123341_(); ++ix) {
                    for (int iy = min.m_123342_(); iy <= max.m_123342_(); ++iy) {
                        for (int iz = min.m_123343_(); iz <= max.m_123343_(); ++iz) {
                            BlockState pistonState;
                            PistonMovingBlockEntity piston;
                            BlockEntity tile;
                            BlockPos test = new BlockPos(ix, iy, iz);
                            BlockState state = this.f_19853_.m_8055_(test);
                            if (state.m_60734_() != Blocks.f_50110_ || !((tile = this.f_19853_.m_7702_(test)) instanceof PistonMovingBlockEntity) || !(piston = (PistonMovingBlockEntity)tile).m_60387_() || !(pistonState = piston.m_60400_()).m_204336_(BREAKS_TORETOISE_ORE) || pistonState.m_61138_((Property)RodBlock.f_52588_) && pistonState.m_61143_((Property)RodBlock.f_52588_) != piston.m_60399_()) continue;
                            this.dropOre(ore, new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42385_)));
                            break block1;
                        }
                    }
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity e = source.m_7640_();
        int ore = this.getOreType();
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack held = living.m_21205_();
            if (ore != 0 && held.m_41720_().canPerformAction(held, ToolActions.PICKAXE_DIG)) {
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (held.m_41763_() && e instanceof Player) {
                        MiscUtil.damageStack((Player)e, InteractionHand.MAIN_HAND, held, 1);
                    }
                    LootContext.Builder lootBuilder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81463_, (Object)held);
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        lootBuilder.m_78963_(player.m_36336_());
                    }
                    this.dropOre(ore, lootBuilder);
                    if (living instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)living;
                        ToretoiseModule.mineToretoiseTrigger.trigger(sp);
                        if (this.isTamed) {
                            ToretoiseModule.mineFedToretoiseTrigger.trigger(sp);
                        }
                    }
                }
                return false;
            }
            if (this.angeryTicks == 0) {
                this.angeryTicks = 20;
                this.lastAggressor = living;
            }
        }
        return super.m_6469_(source, amount);
    }

    public void dropOre(int ore, LootContext.Builder lootContext) {
        lootContext.m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_());
        BlockState dropState = null;
        switch (ore) {
            case 1: {
                dropState = Blocks.f_152469_.m_49966_();
                break;
            }
            case 2: {
                dropState = Blocks.f_152468_.m_49966_();
                break;
            }
            case 3: {
                dropState = Blocks.f_152473_.m_49966_();
                break;
            }
            case 4: {
                dropState = Blocks.f_152472_.m_49966_();
                break;
            }
            case 5: {
                dropState = Blocks.f_152506_.m_49966_();
            }
        }
        if (dropState != null) {
            this.m_5496_(QuarkSounds.ENTITY_TORETOISE_HARVEST, 1.0f, 0.6f);
            this.m_146850_(GameEvent.f_223708_);
            List drops = dropState.m_60724_(lootContext);
            for (ItemStack drop : drops) {
                this.m_5552_(drop, 1.2f);
            }
        }
        this.f_19804_.m_135381_(ORE_TYPE, (Object)0);
        this.m_20011_(this.m_142242_());
    }

    public void m_27595_(Player player) {
        this.m_27601_(0);
    }

    public void m_27601_(int ticks) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.m_5496_(this.eatCooldown == 0 ? QuarkSounds.ENTITY_TORETOISE_EAT : QuarkSounds.ENTITY_TORETOISE_EAT_SATIATED, 0.5f + 0.5f * (float)this.f_19853_.f_46441_.m_188503_(2), (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f + 1.0f);
        this.m_5634_(8.0f);
        if (!this.isTamed) {
            this.isTamed = true;
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.5, 0.5, 0.5, 0.0);
            }
        } else if (this.eatCooldown == 0) {
            this.popOre(false);
        }
    }

    private void popOre(boolean natural) {
        if (!natural && ToretoiseModule.regrowChance == 0) {
            return;
        }
        if (this.getOreType() == 0 && (natural || this.f_19853_.f_46441_.m_188503_(ToretoiseModule.regrowChance) == 0)) {
            int ore = this.f_19796_.m_188503_(5) + 1;
            this.f_19804_.m_135381_(ORE_TYPE, (Object)ore);
            this.m_20011_(this.m_142242_());
            if (!natural) {
                this.eatCooldown = ToretoiseModule.cooldownTicks;
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 100, 0.6, 0.6, 0.6, 0.0);
                    this.m_5496_(QuarkSounds.ENTITY_TORETOISE_REGROW, 10.0f, 0.7f);
                }
            }
        }
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return this.getGoodFood().test(stack);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isTamed;
    }

    public static boolean spawnPredicate(EntityType<? extends Toretoise> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return world.m_46791_() != Difficulty.PEACEFUL && pos.m_123342_() <= ToretoiseModule.maxYLevel && MiscUtil.validSpawnLight(world, pos, rand) && MiscUtil.validSpawnLocation(type, (LevelAccessor)world, reason, pos);
    }

    public boolean m_5545_(@Nonnull LevelAccessor world, @Nonnull MobSpawnType reason) {
        BlockState state = world.m_8055_(new BlockPos(this.m_20182_()).m_7495_());
        if (state.m_60767_() != Material.f_76278_) {
            return false;
        }
        return ToretoiseModule.dimensions.canSpawnHere(world);
    }

    protected void m_6135_() {
    }

    public boolean m_142535_(float distance, float damageMultiplier, @Nonnull DamageSource source) {
        return false;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public boolean m_6573_(@Nonnull Player player) {
        return false;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.6f;
    }

    protected SoundEvent m_7515_() {
        return QuarkSounds.ENTITY_TORETOISE_IDLE;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_TORETOISE_HURT;
    }

    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_TORETOISE_DIE;
    }

    public int getOreType() {
        return (Integer)this.f_19804_.m_135370_(ORE_TYPE);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_(TAG_TAMED, this.isTamed);
        compound.m_128405_(TAG_ORE, this.getOreType());
        compound.m_128405_(TAG_EAT_COOLDOWN, this.eatCooldown);
        compound.m_128405_(TAG_ANGERY_TICKS, this.angeryTicks);
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.isTamed = compound.m_128471_(TAG_TAMED);
        this.f_19804_.m_135381_(ORE_TYPE, (Object)compound.m_128451_(TAG_ORE));
        this.eatCooldown = compound.m_128451_(TAG_EAT_COOLDOWN);
        this.angeryTicks = compound.m_128451_(TAG_ANGERY_TICKS);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.08).m_22268_(Attributes.f_22278_, 1.0);
    }

    public Toretoise getBreedOffspring(@Nonnull ServerLevel sworld, @Nonnull AgeableMob otherParent) {
        Toretoise e = new Toretoise(ToretoiseModule.toretoiseType, this.f_19853_);
        e.m_6074_();
        return e;
    }
}

