/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiplugin.core.recipes.categories;

import com.mojang.blaze3d.vertex.PoseStack;
import ic2.api.recipes.ingridients.inputs.IInput;
import ic2.api.recipes.ingridients.recipes.IRecipeOutput;
import ic2.api.recipes.ingridients.recipes.IRecipeOutputChance;
import ic2.api.recipes.registries.IMachineRecipeList;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.helpers.Formatters;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BasicMachineCategory
implements IRecipeCategory<IMachineRecipeList.RecipeEntry> {
    protected RecipeType<IMachineRecipeList.RecipeEntry> id;
    protected ItemStack stack;
    protected IDrawable background;
    protected IDrawable progress;
    protected IDrawable charge;
    protected IDrawable icon;

    public BasicMachineCategory(IGuiHelper helper, RecipeType<IMachineRecipeList.RecipeEntry> location, ResourceLocation texture, ItemLike provider) {
        this.id = location;
        this.stack = new ItemStack(provider);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.stack);
        this.background = helper.createDrawable(texture, 50, 15, 90, 55);
        this.progress = helper.drawableBuilder(texture, 176, 14, 23, 16).buildAnimated(150, IDrawableAnimated.StartDirection.LEFT, false);
        this.charge = helper.drawableBuilder(texture, 176, 0, 13, 14).buildAnimated(500, IDrawableAnimated.StartDirection.TOP, true);
    }

    public BasicMachineCategory(IGuiHelper helper, RecipeType<IMachineRecipeList.RecipeEntry> id, ItemStack stack, IDrawable background, IDrawable progress, IDrawable charge) {
        this.id = id;
        this.stack = stack;
        this.background = background;
        this.progress = progress;
        this.charge = charge;
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    public RecipeType<IMachineRecipeList.RecipeEntry> getRecipeType() {
        return this.id;
    }

    public Component getTitle() {
        return this.stack.m_41786_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IMachineRecipeList.RecipeEntry recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.progress.draw(stack, 29, 19);
        this.charge.draw(stack, 6, 21);
        IRecipeOutput iRecipeOutput = recipe.getOutput();
        if (iRecipeOutput instanceof IRecipeOutputChance) {
            IRecipeOutputChance chance = (IRecipeOutputChance)iRecipeOutput;
            float luck = chance.getChance();
            MutableComponent text = Component.m_237113_((String)(Formatters.XP_FORMAT.format(luck * 100.0f) + "%"));
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92889_(stack, (Component)text, 85.0f - (float)font.m_92852_((FormattedText)text), 45.0f, 0x404040);
        }
    }

    public List<Component> getTooltipStrings(IMachineRecipeList.RecipeEntry recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        IRecipeOutputChance chance;
        float luck;
        Font font;
        float width;
        IRecipeOutput iRecipeOutput = recipe.getOutput();
        if (iRecipeOutput instanceof IRecipeOutputChance && mouseX >= (double)(85.0f - (width = (float)(font = Minecraft.m_91087_().f_91062_).m_92852_((FormattedText)Component.m_237113_((String)(Formatters.XP_FORMAT.format((luck = (chance = (IRecipeOutputChance)iRecipeOutput).getChance()) * 100.0f) + "%"))))) && mouseX <= 85.0 && mouseY >= 45.0) {
            Objects.requireNonNull(font);
            if (mouseY <= (double)(45.0f + 9.0f)) {
                return ObjectArrayList.of((Object[])new Component[]{Component.m_237115_((String)"jei.ic2.recycler.chance")});
            }
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder layout, IMachineRecipeList.RecipeEntry recipe, IFocusGroup focus) {
        layout.addSlot(RecipeIngredientRole.INPUT, 6, 2).addItemStacks(recipe.getInputs()[0].getComponents());
        layout.addSlot(RecipeIngredientRole.OUTPUT, 66, 20).addItemStacks(recipe.getOutput().getAllOutputs());
    }

    public static class AlloySmelterCategory
    extends BasicMachineCategory {
        public AlloySmelterCategory(IGuiHelper helper, RecipeType<IMachineRecipeList.RecipeEntry> location, ResourceLocation texture, ItemLike provider) {
            super(helper, location, new ItemStack(provider), (IDrawable)helper.createDrawable(texture, 40, 15, 100, 60), (IDrawable)helper.drawableBuilder(texture, 176, 14, 23, 16).buildAnimated(150, IDrawableAnimated.StartDirection.LEFT, false), (IDrawable)helper.drawableBuilder(texture, 176, 0, 13, 14).buildAnimated(500, IDrawableAnimated.StartDirection.TOP, true));
        }

        @Override
        public void draw(IMachineRecipeList.RecipeEntry recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            this.progress.draw(stack, 39, 19);
            this.charge.draw(stack, 16, 21);
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder layout, IMachineRecipeList.RecipeEntry recipe, IFocusGroup focus) {
            ObjectList lists = CollectionUtils.createList();
            for (IInput inputs : recipe.getInputs()) {
                lists.addAll(inputs.getComponents());
            }
            layout.addSlot(RecipeIngredientRole.INPUT, 6, 2).addItemStacks(recipe.getInputs()[0].getComponents());
            layout.addSlot(RecipeIngredientRole.INPUT, 26, 2).addItemStacks(recipe.getInputs()[1].getComponents());
            layout.addSlot(RecipeIngredientRole.OUTPUT, 76, 20).addItemStacks(recipe.getOutput().getAllOutputs());
        }
    }
}

