/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blockentity;

import ic2.api.network.buffer.NetworkInfo;
import ic2.api.recipes.ingridients.inputs.IInput;
import ic2.api.recipes.ingridients.recipes.IRecipeOutput;
import ic2.api.recipes.registries.IMachineRecipeList;
import ic2.api.tiles.IFluidMachine;
import ic2.api.tiles.IInputMachine;
import ic2.api.util.DirectionList;
import ic2.api.util.ILocation;
import ic2.core.block.base.cache.CapabilityCache;
import ic2.core.block.base.cache.ICache;
import ic2.core.block.base.features.IClickable;
import ic2.core.block.base.tiles.impls.machine.single.BaseMachineTileEntity;
import ic2.core.fluid.IC2Tank;
import ic2.core.fluid.InsertionTank;
import ic2.core.inventory.container.IC2Container;
import ic2.core.inventory.filter.IFilter;
import ic2.core.inventory.filter.SpecialFilters;
import ic2.core.inventory.filter.special.ElectricItemFilter;
import ic2.core.inventory.filter.special.MachineFilter;
import ic2.core.inventory.handler.AccessRule;
import ic2.core.inventory.handler.InventoryHandler;
import ic2.core.inventory.handler.SlotType;
import ic2.core.utils.helpers.FluidHelper;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import trinsdar.ic2c_extras.blockentity.TileEntityMultiOutput;
import trinsdar.ic2c_extras.container.ContainerOreWashingPlant;
import trinsdar.ic2c_extras.init.IC2CExtrasSounds;
import trinsdar.ic2c_extras.init.ModBlocks;
import trinsdar.ic2c_extras.recipes.MachineRecipes;

public class TileEntityOreWashingPlant
extends TileEntityMultiOutput
implements Consumer<IC2Tank>,
IClickable,
IFluidMachine {
    @NetworkInfo
    private InsertionTank waterTank = new InsertionTank(16000, fluid -> fluid.getFluid() == Fluids.f_76193_);
    ICache<IFluidHandler> fluidCache = new CapabilityCache((ILocation)this, DirectionList.ALL, ForgeCapabilities.FLUID_HANDLER);

    public TileEntityOreWashingPlant(BlockPos pos, BlockState state) {
        super(pos, state, 5, 8, 400, 32);
        this.addCaches(new ICache[]{this.fluidCache});
        this.addCapability(ForgeCapabilities.FLUID_HANDLER, this.waterTank);
        this.waterTank.addListener((Consumer)this);
        this.addGuiFields(new String[]{"waterTank"});
    }

    public BlockEntityType<?> createType() {
        return ModBlocks.ORE_WASHING_PLANT_TYPE;
    }

    public IC2Tank getWaterTank() {
        return this.waterTank;
    }

    protected void addSlotInfo(InventoryHandler handler) {
        handler.registerBlockSides(DirectionList.ALL);
        handler.registerBlockAccess(DirectionList.ALL, AccessRule.BOTH);
        handler.registerSlotAccess(AccessRule.BOTH, new int[]{0});
        handler.registerSlotAccess(AccessRule.IMPORT, new int[]{1});
        handler.registerSlotAccess(AccessRule.EXPORT, new int[]{2, 3, 4});
        handler.registerSlotsForSide(DirectionList.DOWN.invert(), new int[]{1});
        handler.registerSlotsForSide(DirectionList.UP.invert(), new int[]{0, 2, 3, 4});
        handler.registerInputFilter(SpecialFilters.createChargeFilter(), new int[]{0});
        handler.registerOutputFilter(ElectricItemFilter.NOT_DISCHARGE_FILTER, new int[]{0});
        handler.registerInputFilter((IFilter)new MachineFilter((IInputMachine)this), new int[]{1});
        handler.registerInputFilter(SpecialFilters.ALWAYS_FALSE, new int[]{2, 3, 4});
        handler.registerNamedSlot(SlotType.BATTERY, new int[]{0});
        handler.registerNamedSlot(SlotType.INPUT, new int[]{1});
        handler.registerNamedSlot(SlotType.OUTPUT, new int[]{2, 3, 4});
    }

    protected ResourceLocation getWorkingSound() {
        return IC2CExtrasSounds.ORE_WASHING_PLANT_OP;
    }

    public boolean canProcess() {
        if (this.usedRecipe == null) {
            return false;
        }
        return super.canProcess() && this.waterTank.getFluidAmount() >= TileEntityOreWashingPlant.getRequiredWater(this.usedRecipe.getOutput());
    }

    protected BaseMachineTileEntity.RecipeResult isRecipeStillValid(int slot, IMachineRecipeList.RecipeEntry entry) {
        if (this.waterTank.getFluidAmount() >= TileEntityOreWashingPlant.getRequiredWater(entry.getOutput())) {
            return BaseMachineTileEntity.RecipeResult.IGNORE;
        }
        return BaseMachineTileEntity.RecipeResult.PASS;
    }

    public void operateOnce(int slot, IInput[] input, IRecipeOutput output, CompoundTag recipeData) {
        super.operateOnce(slot, input, output, recipeData);
        this.waterTank.drainInternally(TileEntityOreWashingPlant.getRequiredWater(output), IFluidHandler.FluidAction.EXECUTE);
    }

    public IC2Container createContainer(Player player, InteractionHand hand, Direction side, int windowID) {
        return new ContainerOreWashingPlant(this, player, windowID);
    }

    @Override
    public void accept(IC2Tank tank) {
        this.updateGuiField("waterTank");
        this.addToTick();
        this.rebuildCache |= !this.isOperating();
    }

    public ResourceLocation getTexture() {
        return ContainerOreWashingPlant.GUI_TEXTURE;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.waterTank.readFromNBT(compound.m_128469_("Tank"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Tank", (Tag)this.waterTank.writeToNBT(new CompoundTag()));
    }

    public BlockEntityType<?> m_58903_() {
        return ModBlocks.ORE_WASHING_PLANT_TYPE;
    }

    public IMachineRecipeList getRecipeList() {
        return MachineRecipes.ORE_WASHING_PLANT;
    }

    public static int getRequiredWater(IRecipeOutput output) {
        if (output == null) {
            return 1000;
        }
        return output.getMetadata().m_128451_("amount");
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2, 3, 4};
    }

    public IFluidHandler getConnectedTank(Direction direction) {
        return (IFluidHandler)this.fluidCache.getHandler(direction);
    }

    public boolean onRightClick(Player player, InteractionHand interactionHand, Direction direction, BlockHitResult blockHitResult) {
        ItemStack stack = player.m_21120_(interactionHand);
        return !stack.m_41619_() && FluidHelper.drainContainers((ItemStack)stack, (Player)player, (IFluidHandler)this.waterTank);
    }
}

