/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blockentity;

import ic2.core.block.base.tiles.impls.BaseGeneratorTileEntity;
import ic2.core.inventory.container.IC2Container;
import ic2.core.inventory.handler.InventoryHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import trinsdar.ic2c_extras.container.ContainerThermoElectricGenerator;
import trinsdar.ic2c_extras.init.ModBlocks;
import trinsdar.ic2c_extras.init.ModItems;

public class TileEntityThermoElectricGenerator
extends BaseGeneratorTileEntity {
    protected boolean checkProduction = true;
    int counter = 0;

    public TileEntityThermoElectricGenerator(BlockPos pos, BlockState state) {
        super(pos, state, 6);
        this.tier = 1;
        this.maxStorage = 20000;
    }

    public BlockEntityType<?> createType() {
        return ModBlocks.THERMO_ELECTRIC_GENERATOR_TYPE;
    }

    protected void addSlotInfo(InventoryHandler handler) {
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.production = compound.m_128451_("Production");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Production", this.production);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.checkProduction = true;
    }

    public int getMaxStackSize(int slot) {
        return 1;
    }

    public float getEUProduction() {
        return Math.min(this.storage, this.production);
    }

    public int getProduction() {
        int count = -1;
        for (int i = 0; i < 6; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41720_() != ModItems.PLUTONIUM_RTG) continue;
            ++count;
        }
        if (count == -1) {
            return 0;
        }
        return (int)Math.pow(2.0, count);
    }

    public boolean isConverting() {
        return this.storage + this.production <= this.maxStorage;
    }

    public int getMaxEnergyOutput() {
        return 32 * this.tier;
    }

    public void onLoaded() {
        super.onLoaded();
    }

    public void onTick() {
        int oldEnergy = this.storage;
        if (this.checkProduction) {
            int newProduction = this.getProduction();
            if (this.production != newProduction) {
                this.production = newProduction;
            }
            this.checkProduction = false;
        }
        boolean active = this.gainEnergy();
        if (this.storage > 0 && this.storage > this.maxStorage) {
            this.storage = this.maxStorage;
        }
        this.setActive(active);
        if (oldEnergy != this.storage) {
            this.updateGuiField("storage");
        }
        this.handleComparators();
    }

    public boolean gainEnergy() {
        if (this.isConverting() && this.production > 0) {
            this.storage += this.production;
            this.updateGuiField("storage");
            return true;
        }
        return false;
    }

    public boolean gainFuel() {
        return false;
    }

    public IC2Container createContainer(Player player, InteractionHand interactionHand, Direction direction, int i) {
        return new ContainerThermoElectricGenerator(this, player, i);
    }

    protected void consumeFuel() {
    }

    public boolean needsFuel() {
        return false;
    }

    public int getMaxFuel() {
        return 0;
    }
}

