/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras;

import ic2.api.crops.ICrop;
import ic2.core.block.crops.CropRegistry;
import ic2.core.platform.recipes.misc.AdvRecipeRegistry;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import trinsdar.ic2c_extras.CreativeTabIC2CExtras;
import trinsdar.ic2c_extras.IC2CExtrasConfig;
import trinsdar.ic2c_extras.IC2CExtrasWorldgen;
import trinsdar.ic2c_extras.block.CropPlumbilia;
import trinsdar.ic2c_extras.datagen.IC2CExtrasBlockTagProvider;
import trinsdar.ic2c_extras.datagen.IC2CExtrasItemTagProvider;
import trinsdar.ic2c_extras.event.PlayerEvents;
import trinsdar.ic2c_extras.init.IC2CExtrasSounds;
import trinsdar.ic2c_extras.init.ModBlocks;
import trinsdar.ic2c_extras.init.ModItems;
import trinsdar.ic2c_extras.recipes.CraftingRecipes;
import trinsdar.ic2c_extras.recipes.MachineRecipes;

@Mod(value="ic2c_extras")
public class IC2CExtras {
    public static final String MODID = "ic2c_extras";
    public static final CreativeModeTab CREATIVE_TAB = new CreativeTabIC2CExtras("ic2c_extras");
    public static Logger LOGGER = LogManager.getLogger((String)"ic2c_extras");

    public IC2CExtras() {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherDataEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        IC2CExtrasConfig.createConfig();
    }

    private void registerEvent(RegisterEvent event) {
        if (event.getRegistryKey() == ForgeRegistries.Keys.BLOCKS) {
            ModBlocks.init();
            ModItems.init();
            IC2CExtrasSounds.init();
        } else if (event.getRegistryKey() == ForgeRegistries.Keys.FEATURES) {
            IC2CExtrasWorldgen.init();
        } else if (event.getRegistryKey() == ForgeRegistries.Keys.BIOME_MODIFIERS) {
            event.getForgeRegistry().register(new ResourceLocation(MODID, "modifier"), (Object)new IC2CExtrasWorldgen.IC2CExtrasModifier());
        } else if (event.getRegistryKey() == ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS) {
            event.getForgeRegistry().register(new ResourceLocation(MODID, "modifier"), IC2CExtrasWorldgen.IC2CExtrasModifier.CODEC);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AdvRecipeRegistry.INSTANCE.registerListener(CraftingRecipes::loadRecipes);
        MachineRecipes.init();
        CropRegistry.REGISTRY.registerCrop((ICrop)new CropPlumbilia());
    }

    private void gatherDataEvent(GatherDataEvent event) {
        IC2CExtrasBlockTagProvider provider = new IC2CExtrasBlockTagProvider(event.getGenerator(), event.getExistingFileHelper());
        event.getGenerator().m_236039_(true, (DataProvider)provider);
        event.getGenerator().m_236039_(true, (DataProvider)new IC2CExtrasItemTagProvider(event.getGenerator(), provider, event.getExistingFileHelper()));
    }
}

