/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blockentity;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import tesseract.TesseractCapUtils;
import tesseract.api.heat.IHeatHandler;
import trinsdar.ic2c_extras.blockentity.IHeatTile;

public class Ic2cExtrasHeatHandler
implements IHeatHandler {
    int heat;
    int maxHeat;
    final int maxInput;
    final int maxOutput;
    final IHeatTile owner;

    public Ic2cExtrasHeatHandler(int maxHeat, int maxInput, int maxOutput, IHeatTile owner) {
        this.maxHeat = maxHeat;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.owner = owner;
    }

    public void deserialize(CompoundTag nbt) {
        this.heat = nbt.m_128451_("heat");
        this.maxHeat = nbt.m_128451_("maxHeat");
    }

    public CompoundTag serialize(CompoundTag nbt) {
        nbt.m_128405_("heat", this.heat);
        nbt.m_128405_("maxHeat", this.maxHeat);
        return nbt;
    }

    public int insert(int heat, boolean simulate) {
        if (!this.canInput()) {
            return 0;
        }
        int insert = Math.min(this.maxInput, Math.min(this.maxHeat - this.heat, heat));
        return this.insertInternal(insert, simulate);
    }

    public int extract(int heat, boolean simulate) {
        if (!this.canOutput()) {
            return 0;
        }
        int extract = Math.min(this.maxOutput, Math.min(this.heat, heat));
        return this.extractInternal(extract, simulate);
    }

    public int insertInternal(int heat, boolean simulate) {
        int insert = Math.min(this.maxHeat - this.heat, heat);
        if (!simulate) {
            this.heat += insert;
        }
        return insert;
    }

    public int extractInternal(int heat, boolean simulate) {
        int extract = Math.min(this.heat, heat);
        if (!simulate) {
            this.heat -= extract;
        }
        return extract;
    }

    public int getHeat() {
        return this.heat;
    }

    public int getHeatCap() {
        return this.maxHeat;
    }

    public void update(boolean active) {
        for (Direction dir : Direction.values()) {
            Optional handle;
            BlockEntity tile;
            if (!this.canOutput(dir) || (tile = this.owner.getOwner().m_58904_().m_7702_(this.owner.getOwner().m_58899_().m_121945_(dir))) == null || (handle = TesseractCapUtils.INSTANCE.getHeatHandler(tile, dir.m_122424_())).map(h -> !h.canInput(dir.m_122424_())).orElse(true).booleanValue()) continue;
            handle.ifPresent(eh -> Ic2cExtrasHeatHandler.transferHeat(this, eh));
        }
    }

    public static void transferHeat(IHeatHandler from, IHeatHandler to) {
        int inserted;
        int extracted = from.extract(Integer.MAX_VALUE, true);
        if (extracted > 0 && (inserted = to.insert(extracted, false)) > 0) {
            from.extract(inserted, false);
        }
    }

    public boolean canOutput() {
        return this.maxOutput > 0;
    }

    public boolean canInput() {
        return this.maxInput > 0;
    }

    public boolean canInput(Direction direction) {
        return this.canInput() && this.owner.canInput(direction);
    }

    public boolean canOutput(Direction direction) {
        return this.canOutput() && this.owner.canOutput(direction);
    }

    public long getMaxInsert() {
        return this.maxInput;
    }

    public long getMaxExtract() {
        return this.maxOutput;
    }
}

