/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blockentity;

import ic2.api.network.buffer.NetworkInfo;
import ic2.api.recipes.ingridients.inputs.IInput;
import ic2.api.recipes.ingridients.recipes.IRecipeOutput;
import ic2.api.recipes.registries.IMachineRecipeList;
import ic2.api.tiles.IFluidMachine;
import ic2.api.tiles.readers.ISpeedMachine;
import ic2.api.util.DirectionList;
import ic2.api.util.ILocation;
import ic2.core.block.base.cache.CapabilityCache;
import ic2.core.block.base.cache.ICache;
import ic2.core.block.base.features.IClickable;
import ic2.core.block.base.features.IXPMachine;
import ic2.core.block.base.tiles.impls.machine.single.BaseAdvMachineTileEntity;
import ic2.core.block.base.tiles.impls.machine.single.BaseMachineTileEntity;
import ic2.core.block.machines.containers.mv.AdvMachineContainer;
import ic2.core.block.machines.tiles.mv.InductionFurnaceTileEntity;
import ic2.core.fluid.InsertionTank;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.gui.components.GuiWidget;
import ic2.core.inventory.gui.components.simple.SpeedComponent;
import ic2.core.inventory.gui.components.simple.TankComponent;
import ic2.core.inventory.slot.FilterSlot;
import ic2.core.inventory.slot.XPSlot;
import ic2.core.utils.helpers.FluidHelper;
import ic2.core.utils.math.geometry.Box2i;
import ic2.core.utils.math.geometry.Vec2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import trinsdar.ic2c_extras.blockentity.TileEntityOreWashingPlant;
import trinsdar.ic2c_extras.init.IC2CExtrasSounds;
import trinsdar.ic2c_extras.init.ModBlocks;
import trinsdar.ic2c_extras.recipes.MachineRecipes;

public class TileEntityThermalWasher
extends BaseAdvMachineTileEntity
implements IClickable,
IFluidMachine {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("ic2c_extras", "textures/gui/thermal_washer.png");
    @NetworkInfo
    private InsertionTank waterTank = new InsertionTank(16000, fluid -> fluid.getFluid() == Fluids.f_76193_);
    ICache<IFluidHandler> fluidCache = new CapabilityCache((ILocation)this, DirectionList.ALL, ForgeCapabilities.FLUID_HANDLER);

    public TileEntityThermalWasher(BlockPos pos, BlockState state) {
        super(pos, state, 5, 16, 4000);
        this.addCaches(new ICache[]{this.fluidCache});
        this.addCapability(ForgeCapabilities.FLUID_HANDLER, this.waterTank);
        this.waterTank.addListener(tank -> {
            this.updateGuiField("waterTank");
            this.addToTick();
            this.rebuildCache |= !this.isOperating();
        });
        this.addGuiFields(new String[]{"waterTank"});
    }

    public int[] getOutputSlots() {
        return new int[]{2, 3, 4};
    }

    public Slot[] addSlots(Player player) {
        return new Slot[]{FilterSlot.createDischargeSlot((IHasInventory)this, (int)this.tier, (int)0, (int)56, (int)53), new FilterSlot((IHasInventory)this, 1, 56, 17, T -> this.getRecipeList().getRecipe(T, false) != null), new XPSlot((IXPMachine)this, 2, 111, 17), new XPSlot((IXPMachine)this, 3, 111, 35), new XPSlot((IXPMachine)this, 4, 111, 53)};
    }

    public void addComponents(AdvMachineContainer container) {
        container.getComponents().remove(0);
        container.addComponent((GuiWidget)new SpeedComponent((ISpeedMachine)this, this.getSpeedName(), new Vec2i(80, 53)));
        container.addComponent((GuiWidget)new TankComponent(new Box2i(32, 13, 16, 58), new Vec2i(176, 133), (IFluidTank)this.waterTank).setTankName("Water Tank"));
    }

    public Component getSpeedName() {
        return InductionFurnaceTileEntity.HEAT;
    }

    public ResourceLocation getTexture() {
        return GUI_TEXTURE;
    }

    public BlockEntityType<?> createType() {
        return ModBlocks.THERMAL_WASHER_TYPE;
    }

    public IMachineRecipeList getRecipeList() {
        return MachineRecipes.ORE_WASHING_PLANT;
    }

    protected ResourceLocation getWorkingSound() {
        return IC2CExtrasSounds.ORE_WASHING_PLANT_OP;
    }

    protected BaseMachineTileEntity.RecipeResult isRecipeStillValid(int slot, IMachineRecipeList.RecipeEntry entry) {
        if (this.waterTank.getFluidAmount() >= TileEntityOreWashingPlant.getRequiredWater(entry.getOutput())) {
            return BaseMachineTileEntity.RecipeResult.IGNORE;
        }
        return BaseMachineTileEntity.RecipeResult.PASS;
    }

    public void operateOnce(int slot, IInput[] input, IRecipeOutput output, CompoundTag recipeData) {
        super.operateOnce(slot, input, output, recipeData);
        this.waterTank.drainInternally(TileEntityOreWashingPlant.getRequiredWater(output), IFluidHandler.FluidAction.EXECUTE);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.waterTank.readFromNBT(compound.m_128469_("Tank"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Tank", (Tag)this.waterTank.writeToNBT(new CompoundTag()));
    }

    public IFluidHandler getConnectedTank(Direction direction) {
        return (IFluidHandler)this.fluidCache.getHandler(direction);
    }

    public boolean onRightClick(Player player, InteractionHand interactionHand, Direction direction, BlockHitResult blockHitResult) {
        ItemStack stack = player.m_21120_(interactionHand);
        return !stack.m_41619_() && FluidHelper.drainContainers((ItemStack)stack, (Player)player, (IFluidHandler)this.waterTank);
    }
}

