/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.container.component;

import com.mojang.blaze3d.vertex.PoseStack;
import ic2.core.inventory.gui.components.GuiWidget;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.math.geometry.Box2i;
import ic2.core.utils.math.geometry.Vec2i;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import trinsdar.ic2c_extras.blockentity.TileEntityThermalCentrifuge;

public class HeatComponent
extends GuiWidget {
    TileEntityThermalCentrifuge block;
    Vec2i texPos;

    public HeatComponent(TileEntityThermalCentrifuge tile, Box2i box, Vec2i pos) {
        super(box);
        this.block = tile;
        this.texPos = pos;
    }

    protected void addRequests(Set<GuiWidget.ActionRequest> set) {
        set.addAll(Arrays.asList(GuiWidget.ActionRequest.DRAW_BACKGROUND, GuiWidget.ActionRequest.TOOLTIP));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        float heat = this.block.getHeat();
        if (heat > 0.0f) {
            Box2i box;
            int maxX;
            int lvl;
            int x = this.gui.getGuiLeft();
            int y = this.gui.getGuiTop();
            float per = heat / (float)this.block.maxHeat;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * (float)(maxX = (box = this.getBox()).getWidth()))) <= 0) {
                return;
            }
            this.gui.drawTextureRegion(matrix, (float)(x + box.getX()), (float)(y + box.getY()), (float)this.texPos.getX(), (float)this.texPos.getY(), (float)lvl, (float)box.getHeight());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addTooltips(PoseStack matrix, int mouseX, int mouseY, Consumer<Component> tooltips) {
        if (this.isMouseOver(mouseX, mouseY) && this.hasEUReader()) {
            tooltips.accept((Component)this.translate("gui.ic2c_extras.heat", new Object[]{Formatters.EU_FORMAT.format((double)this.block.heat), Formatters.EU_FORMAT.format((double)this.block.maxHeat)}));
        }
    }
}

