/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.recipes;

import ic2.api.recipes.registries.IAdvancedCraftingManager;
import ic2.core.IC2;
import ic2.core.item.reactor.base.IUraniumRod;
import ic2.core.item.reactor.urantypes.BlazeUranium;
import ic2.core.item.reactor.urantypes.CharcoalUranium;
import ic2.core.item.reactor.urantypes.EnderUranium;
import ic2.core.item.reactor.urantypes.NetherStarUranium;
import ic2.core.item.reactor.urantypes.RedstoneUranium;
import ic2.core.platform.registries.IC2Blocks;
import ic2.core.platform.registries.IC2Items;
import ic2.core.platform.registries.IC2Tags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import trinsdar.ic2c_extras.IC2CExtrasConfig;
import trinsdar.ic2c_extras.init.IC2CExtrasTags;
import trinsdar.ic2c_extras.init.ModBlocks;
import trinsdar.ic2c_extras.init.ModItems;
import trinsdar.ic2c_extras.nuclear.MOX;
import trinsdar.ic2c_extras.nuclear.Plutonium;
import trinsdar.ic2c_extras.nuclear.Thorium232;
import trinsdar.ic2c_extras.nuclear.Uranium233;
import trinsdar.ic2c_extras.nuclear.Uranium235;
import trinsdar.ic2c_extras.nuclear.Uranium238;

public class CraftingRecipes {
    public static void loadRecipes(IAdvancedCraftingManager registry) {
        if (IC2CExtrasConfig.DISABLE_NON_RADIATION.get()) {
            return;
        }
        CraftingRecipes.addDustRecipe(registry, "iron", IC2Items.DUST_IRON, ModItems.TINY_IRON_DUST);
        CraftingRecipes.addDustRecipe(registry, "gold", IC2Items.DUST_GOLD, ModItems.TINY_GOLD_DUST);
        CraftingRecipes.addDustRecipe(registry, "copper", IC2Items.DUST_COPPER, ModItems.TINY_COPPER_DUST);
        CraftingRecipes.addDustRecipe(registry, "tin", IC2Items.DUST_TIN, ModItems.TINY_TIN_DUST);
        CraftingRecipes.addDustRecipe(registry, "aluminium", IC2Items.DUST_ALUMINIUM, ModItems.TINY_ALUMINIUM_DUST);
        CraftingRecipes.addDustRecipe(registry, "silver", IC2Items.DUST_SILVER, ModItems.TINY_SILVER_DUST);
        CraftingRecipes.addDustRecipe(registry, "lead", ModItems.LEAD_DUST, ModItems.TINY_LEAD_DUST);
        CraftingRecipes.addDustRecipe(registry, "uranium233", ModItems.URANIUM_233_DUST, ModItems.TINY_URANIUM_233_DUST);
        CraftingRecipes.addDustRecipe(registry, "uranium235", ModItems.URANIUM_235_DUST, ModItems.TINY_URANIUM_235_DUST);
        CraftingRecipes.addDustRecipe(registry, "uranium", ModItems.URANIUM_DUST, ModItems.TINY_URANIUM_238_DUST);
        CraftingRecipes.addDustRecipe(registry, "plutonium", ModItems.PLUTONIUM_DUST, ModItems.TINY_PLUTONIUM_DUST);
        CraftingRecipes.addDustRecipe(registry, "thorium", ModItems.THORIUM_DUST, ModItems.TINY_THORIUM_DUST);
        registry.addShapedRecipe(CraftingRecipes.id("thermal_centrifuge"), new ItemStack((ItemLike)ModBlocks.THERMAL_CENTRIFUGE), new Object[]{"CLC", "RMR", "RHR", Character.valueOf('C'), ModItems.COIL, Character.valueOf('L'), IC2Items.MINING_LASER, Character.valueOf('R'), IC2Tags.INGOT_REFINED_IRON, Character.valueOf('M'), IC2Blocks.ADVANCED_MACHINE_BLOCK, Character.valueOf('H'), ModItems.HEAT_CONDUCTOR});
        registry.addShapedRecipe(CraftingRecipes.id("coil"), new ItemStack((ItemLike)ModItems.COIL), new Object[]{"CCC", "CRC", "CCC", Character.valueOf('C'), IC2Items.COPPER_CABLE, Character.valueOf('R'), IC2Tags.INGOT_REFINED_IRON});
        registry.addShapedRecipe(CraftingRecipes.id("heat_conductor"), new ItemStack((ItemLike)ModItems.HEAT_CONDUCTOR), new Object[]{"RRC", "RCR", "CRR", Character.valueOf('R'), IC2Items.RUBBER, Character.valueOf('C'), IC2Tags.INGOT_COPPER});
        registry.addShapedRecipe(new ResourceLocation(IC2CExtrasConfig.REACTOR_CHAMBER_REQUIRES_LEAD.get() ? "ic2" : "ic2c_extras", "reactor_chamber"), new ItemStack((ItemLike)IC2Blocks.REACTOR_CHAMBER), new Object[]{" D ", "DMD", " D ", Character.valueOf('D'), ModItems.DENSE_LEAD_PLATE, Character.valueOf('M'), IC2Blocks.MACHINE_BLOCK});
        registry.addShapedRecipe(CraftingRecipes.id("ore_washing_plant"), new ItemStack((ItemLike)ModBlocks.ORE_WASHING_PLANT), new Object[]{"RRR", "BMB", "cCc", Character.valueOf('R'), IC2Tags.INGOT_REFINED_IRON, Character.valueOf('B'), Items.f_42446_, Character.valueOf('M'), IC2Blocks.MACHINE_BLOCK, Character.valueOf('c'), IC2Items.CARBON_MESH, Character.valueOf('C'), IC2Items.CIRCUIT});
        registry.addShapedRecipe(CraftingRecipes.id("thermal_washer"), new ItemStack((ItemLike)ModBlocks.THERMAL_WASHER), new Object[]{"BBB", "BOB", "BMB", Character.valueOf('B'), Items.f_42446_, Character.valueOf('O'), ModBlocks.ORE_WASHING_PLANT, Character.valueOf('M'), IC2Blocks.ADVANCED_MACHINE_BLOCK});
        registry.addShapelessRecipe(new ResourceLocation("ic2c_extras", "plating"), new ItemStack((ItemLike)IC2Items.PLATING), new Object[]{IC2CExtrasTags.getForgeItemTag("ingots/lead"), IC2Items.PLATE_ADVANCED_ALLOY});
        registry.addShapedRecipe(new ResourceLocation("ic2c_extras", "containment_box"), new ItemStack((ItemLike)ModItems.CONTAINMENT_BOX), new Object[]{" L ", "LCL", " L ", Character.valueOf('L'), IC2CExtrasTags.getForgeItemTag("ingots/lead"), Character.valueOf('C'), IC2CExtrasTags.getForgeItemTag("chests/wooden")});
        registry.addShapelessIC2Recipe("uranium__single_2", new ItemStack((ItemLike)IC2Items.URANIUM_ROD_SINGLE), new Object[]{CraftingRecipes.getEmptyNuclearCell(), CraftingRecipes.getUraniumRodIngredient()});
        registry.removeCraftingRecipe(new ResourceLocation("ic2", "uranium__single_2_tag"));
        registry.removeCraftingRecipe(new ResourceLocation("ic2", "uranium__near_depleted_tag"));
        registry.addShapedIC2Recipe("uranium__near_depleted", new ItemStack((ItemLike)IC2Items.URANIUM_ROD_NEAR_DEPLETED, 8), new Object[]{"CCC", "CUC", "CCC", Character.valueOf('C'), CraftingRecipes.getEmptyNuclearCell(), Character.valueOf('U'), CraftingRecipes.getUraniumRodIngredient()});
        if (IC2CExtrasConfig.EMPTY_NUCLEAR_ROD.get()) {
            IUraniumRod[] rods;
            registry.addShapedRecipe(CraftingRecipes.id("empty_nuclear_rod"), new ItemStack((ItemLike)ModItems.EMPTY_NUCLEAR_ROD, 4), new Object[]{" I ", "I I", " I ", Character.valueOf('I'), IC2Tags.INGOT_REFINED_IRON});
            registry.addShapedIC2Recipe("uranium_redstone_near_depleted", new ItemStack((ItemLike)IC2Items.URANIUM_ROD_NEAR_DEPLETED_REDSTONE, 8), new Object[]{"CCC", "CUC", "CCC", Character.valueOf('C'), CraftingRecipes.getEmptyNuclearCell(), Character.valueOf('U'), IC2Items.INGOT_URANIUM_ENRICHED_REDSTONE});
            registry.addShapedIC2Recipe("uranium_blaze_near_depleted", new ItemStack((ItemLike)IC2Items.URANIUM_ROD_NEAR_DEPLETED_BLAZE, 8), new Object[]{"CCC", "CUC", "CCC", Character.valueOf('C'), CraftingRecipes.getEmptyNuclearCell(), Character.valueOf('U'), IC2Items.INGOT_URANIUM_ENRICHED_BLAZE});
            registry.addShapedIC2Recipe("uranium_ender_near_depleted", new ItemStack((ItemLike)IC2Items.URANIUM_ROD_NEAR_DEPLETED_ENDER_PEARL, 8), new Object[]{"CCC", "CUC", "CCC", Character.valueOf('C'), CraftingRecipes.getEmptyNuclearCell(), Character.valueOf('U'), IC2Items.INGOT_URANIUM_ENRICHED_ENDERPEARL});
            registry.addShapedIC2Recipe("uranium_nether_star_near_depleted", new ItemStack((ItemLike)IC2Items.URANIUM_ROD_NEAR_DEPLETED_NETHER_STAR, 8), new Object[]{"CCC", "CUC", "CCC", Character.valueOf('C'), CraftingRecipes.getEmptyNuclearCell(), Character.valueOf('U'), IC2Items.INGOT_URANIUM_ENRICHED_NETHERSTAR});
            registry.addShapedIC2Recipe("uranium_charcoal_near_depleted", new ItemStack((ItemLike)IC2Items.URANIUM_ROD_NEAR_DEPLETED_CHARCOAL, 8), new Object[]{"CCC", "CUC", "CCC", Character.valueOf('C'), CraftingRecipes.getEmptyNuclearCell(), Character.valueOf('U'), IC2Items.INGOT_URANIUM_ENRICHED_CHARCOAL});
            for (IUraniumRod rod : rods = new IUraniumRod[]{RedstoneUranium.INSTANCE, BlazeUranium.INSTANCE, EnderUranium.INSTANCE, NetherStarUranium.INSTANCE, CharcoalUranium.INSTANCE}) {
                if (rod.isEnrichedUranium() && IC2.CONFIG.enableHardEnrichedUranium.get()) continue;
                registry.addShapelessIC2Recipe("uranium_" + rod.getName() + "_single_2", rod.createSingleRod(), new Object[]{CraftingRecipes.getEmptyNuclearCell(), rod.getBaseIngot()});
            }
        }
        if (IC2CExtrasConfig.EXTRA_NUCLEAR.get()) {
            registry.addShapedRecipe(CraftingRecipes.id("thermo_electric_generator"), new ItemStack((ItemLike)ModBlocks.THERMO_ELECTRIC_GENERATOR), new Object[]{"III", "IRI", "ITI", Character.valueOf('I'), ModItems.DENSE_IRON_PLATE, Character.valueOf('R'), IC2Blocks.NUCLEAR_REACTOR, Character.valueOf('T'), IC2Blocks.THERMAL_GENERATOR});
            registry.addShapedRecipe(CraftingRecipes.id("plutonium_rtg"), new ItemStack((ItemLike)ModItems.PLUTONIUM_RTG), new Object[]{"IPI", "IPI", "IPI", Character.valueOf('I'), ModItems.DENSE_IRON_PLATE, Character.valueOf('P'), IC2CExtrasTags.getForgeItemTag("ingots/plutonium")});
            registry.addShapedRecipe(CraftingRecipes.id("mox_fuel"), new ItemStack((ItemLike)ModItems.MOX_FUEL, 3), new Object[]{"UUU", "PPP", "UUU", Character.valueOf('U'), IC2CExtrasTags.getForgeItemTag("dusts/uranium"), Character.valueOf('P'), IC2CExtrasTags.getForgeItemTag("tiny_dusts/plutonium")});
            registry.addShapedRecipe(CraftingRecipes.id("enriched_uranium_fuel"), new ItemStack((ItemLike)ModItems.ENRICHED_URANIUM_FUEL, 3), new Object[]{"UUU", "PPP", "UUU", Character.valueOf('U'), IC2CExtrasTags.getForgeItemTag("dusts/uranium"), Character.valueOf('P'), IC2CExtrasTags.getForgeItemTag("tiny_dusts/uranium235")});
            CraftingRecipes.addRodRecipes(registry, (IUraniumRod)MOX.INSTANCE);
            CraftingRecipes.addRodRecipes(registry, (IUraniumRod)Plutonium.INSTANCE);
            CraftingRecipes.addRodRecipes(registry, (IUraniumRod)Thorium232.INSTANCE);
            CraftingRecipes.addRodRecipes(registry, (IUraniumRod)Uranium233.INSTANCE);
            CraftingRecipes.addRodRecipes(registry, (IUraniumRod)Uranium235.INSTANCE);
            CraftingRecipes.addRodRecipes(registry, (IUraniumRod)Uranium238.INSTANCE);
        }
        CraftingRecipes.loadSmeltingRecipe(registry);
    }

    private static void loadSmeltingRecipe(IAdvancedCraftingManager registry) {
        CraftingRecipes.addCrushedSmeltingRecipe(registry, "iron", Items.f_42416_, 0.35f);
        CraftingRecipes.addCrushedSmeltingRecipe(registry, "gold", Items.f_42417_, 0.5f);
        CraftingRecipes.addCrushedSmeltingRecipe(registry, "copper", Items.f_151052_, 0.15f);
        CraftingRecipes.addCrushedSmeltingRecipe(registry, "tin", IC2Items.INGOT_TIN, 0.2f);
        CraftingRecipes.addCrushedSmeltingRecipe(registry, "silver", IC2Items.INGOT_SILVER, 0.4f);
        CraftingRecipes.addCrushedSmeltingRecipe(registry, "lead", ModItems.LEAD_INGOT, 0.4f);
        registry.addSmeltingRecipe(CraftingRecipes.id("lead_dust"), new ItemStack((ItemLike)ModItems.LEAD_INGOT), IC2CExtrasTags.getForgeItemTag("dusts/lead"), 0.4f, new IAdvancedCraftingManager.SmeltingType[]{IAdvancedCraftingManager.SmeltingType.BLASTFURNACE, IAdvancedCraftingManager.SmeltingType.FURNACE});
    }

    private static void addCrushedSmeltingRecipe(IAdvancedCraftingManager registry, String dust, Item output, float xp) {
        registry.addSmeltingRecipe(CraftingRecipes.id("crushed_" + dust + "_to_ingot"), new ItemStack((ItemLike)output), IC2CExtrasTags.getForgeItemTag("crushed_ores/" + dust), xp, new IAdvancedCraftingManager.SmeltingType[]{IAdvancedCraftingManager.SmeltingType.BLASTFURNACE, IAdvancedCraftingManager.SmeltingType.FURNACE});
        registry.addSmeltingRecipe(CraftingRecipes.id("purified_" + dust + "_to_ingot"), new ItemStack((ItemLike)output), IC2CExtrasTags.getForgeItemTag("purified_ores/" + dust), xp, new IAdvancedCraftingManager.SmeltingType[]{IAdvancedCraftingManager.SmeltingType.BLASTFURNACE, IAdvancedCraftingManager.SmeltingType.FURNACE});
    }

    public static Item getUraniumRodIngredientItem() {
        return IC2CExtrasConfig.EXTRA_NUCLEAR.get() ? ModItems.ENRICHED_URANIUM_INGOT : IC2Items.INGOT_URANIUM;
    }

    public static Object getUraniumRodIngredient() {
        return IC2CExtrasConfig.EXTRA_NUCLEAR.get() ? ModItems.ENRICHED_URANIUM_INGOT : IC2Tags.INGOT_URANIUM;
    }

    public static Item getEmptyNuclearCell() {
        return IC2CExtrasConfig.EMPTY_NUCLEAR_ROD.get() ? ModItems.EMPTY_NUCLEAR_ROD : IC2Items.CELL_EMPTY;
    }

    private static void addDustRecipe(IAdvancedCraftingManager registry, String dust, Item output, Item tiny) {
        registry.addShapelessRecipe(CraftingRecipes.id(dust + "_dust"), new ItemStack((ItemLike)output), new Object[]{IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust), IC2CExtrasTags.getForgeItemTag("tiny_dusts/" + dust)});
        registry.addShapelessRecipe(CraftingRecipes.id(dust + "_tiny_dust"), new ItemStack((ItemLike)tiny, 9), new Object[]{IC2CExtrasTags.getForgeItemTag("dusts/" + dust)});
    }

    private static void addRodRecipes(IAdvancedCraftingManager recipes, IUraniumRod rod) {
        String tag = rod == Uranium238.INSTANCE ? "uranium" : rod.getName().replace("_", "");
        recipes.addShapedRecipe(CraftingRecipes.id("near_depleted_" + rod.getName()), rod.createNearDepletedRod(8), new Object[]{"XXX", "XYX", "XXX", Character.valueOf('Y'), IC2CExtrasTags.getForgeItemTag("ingots/" + tag), Character.valueOf('X'), CraftingRecipes.getEmptyNuclearCell()});
        recipes.addShapelessRecipe(CraftingRecipes.id("isotopic_" + rod.getName() + "_0"), rod.createIsotopicRod(), new Object[]{rod.createNearDepletedRod(1), IC2Tags.DUST_COAL});
        recipes.addShapelessRecipe(CraftingRecipes.id("isotopic_" + rod.getName() + "_1"), rod.createIsotopicRod(), new Object[]{rod.createNearDepletedRod(), IC2Tags.DUST_CHARCOAL});
        recipes.addShapelessRecipe(CraftingRecipes.id("single_" + rod.getName() + "_0"), rod.createSingleRod(), new Object[]{IC2Tags.DUST_COAL, rod.createReEnrichedRod()});
        recipes.addShapelessRecipe(CraftingRecipes.id("single_" + rod.getName() + "_1"), rod.createSingleRod(), new Object[]{IC2Tags.DUST_CHARCOAL, rod.createReEnrichedRod()});
        recipes.addShapedRecipe(CraftingRecipes.id("dual_" + rod.getName()), rod.createDualRod(), new Object[]{"UCU", Character.valueOf('U'), rod.createSingleRod(), Character.valueOf('C'), IC2Items.PLATE_DENSE_COPPER});
        recipes.addShapedRecipe(CraftingRecipes.id("quad_" + rod.getName() + "_0"), rod.createQuadRod(), new Object[]{" U ", "CCC", " U ", Character.valueOf('U'), rod.createDualRod(), Character.valueOf('C'), IC2Items.PLATE_DENSE_COPPER});
        recipes.addShapedRecipe(CraftingRecipes.id("quad_" + rod.getName() + "_1"), rod.createQuadRod(), new Object[]{"UCU", "CCC", "UCU", Character.valueOf('U'), rod.createSingleRod(), Character.valueOf('C'), IC2Items.PLATE_DENSE_COPPER});
        if (!rod.isEnrichedUranium() || !IC2.CONFIG.enableHardEnrichedUranium.get()) {
            recipes.addShapelessRecipe(CraftingRecipes.id("single_" + rod.getName() + "_2"), rod.createSingleRod(), new Object[]{CraftingRecipes.getEmptyNuclearCell(), IC2CExtrasTags.getForgeItemTag("ingots/" + tag)});
        }
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation("ic2c_extras", id);
    }
}

