/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.recipes;

import ic2.api.recipes.ingridients.inputs.IInput;
import ic2.api.recipes.ingridients.inputs.ItemInput;
import ic2.api.recipes.ingridients.inputs.ItemTagInput;
import ic2.api.recipes.misc.RecipeMods;
import ic2.api.recipes.registries.IMachineRecipeList;
import ic2.core.IC2;
import ic2.core.block.machines.recipes.misc.EnrichRecipe;
import ic2.core.item.reactor.base.IUraniumRod;
import ic2.core.platform.recipes.misc.GlobalRecipes;
import ic2.core.platform.registries.IC2Blocks;
import ic2.core.platform.registries.IC2Items;
import ic2.core.platform.registries.IC2Tags;
import ic2.core.utils.math.ColorUtils;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.loading.FMLEnvironment;
import trinsdar.ic2c_extras.IC2CExtrasConfig;
import trinsdar.ic2c_extras.init.IC2CExtrasTags;
import trinsdar.ic2c_extras.init.ModItems;
import trinsdar.ic2c_extras.nuclear.MOX;
import trinsdar.ic2c_extras.nuclear.Plutonium;
import trinsdar.ic2c_extras.nuclear.Thorium232;
import trinsdar.ic2c_extras.nuclear.Uranium233;
import trinsdar.ic2c_extras.nuclear.Uranium235;
import trinsdar.ic2c_extras.nuclear.Uranium238;
import trinsdar.ic2c_extras.recipes.CraftingRecipes;
import trinsdar.ic2c_extras.recipes.recipelists.ExtendedRecipeList;

public class MachineRecipes {
    public static final ExtendedRecipeList ORE_WASHING_PLANT = new ExtendedRecipeList("ore_washing_plant", MachineRecipes::initOreWasherRecipes);
    public static final ExtendedRecipeList THERMAL_CENTRIFUGE = new ExtendedRecipeList("thermal_centrifuge", MachineRecipes::initThermalCentrifugeRecipes);

    public static void init() {
        ((GlobalRecipes)IC2.RECIPES.get(true)).getLists().add(ORE_WASHING_PLANT);
        ((GlobalRecipes)IC2.RECIPES.get(true)).getLists().add(THERMAL_CENTRIFUGE);
        if (FMLEnvironment.dist.isClient()) {
            ((GlobalRecipes)IC2.RECIPES.get(false)).getLists().add(ORE_WASHING_PLANT);
            ((GlobalRecipes)IC2.RECIPES.get(false)).getLists().add(THERMAL_CENTRIFUGE);
        }
        ((GlobalRecipes)IC2.RECIPES.get((boolean)true)).macerator.registerListener(MachineRecipes::initMaceratorRecipes);
        ((GlobalRecipes)IC2.RECIPES.get((boolean)true)).extractor.registerListener(r -> {
            if (IC2CExtrasConfig.EXTRA_NUCLEAR.get() && !IC2CExtrasConfig.DISABLE_NON_RADIATION.get()) {
                r.removeRecipe(new ResourceLocation("ic2", "uranium_extraction"));
            }
        });
        ((GlobalRecipes)IC2.RECIPES.get((boolean)true)).compressor.registerListener(r -> {
            if (IC2CExtrasConfig.DISABLE_NON_RADIATION.get()) {
                return;
            }
            r.addSimpleRecipe(CraftingRecipes.id("dense_lead_plate"), new ItemStack((ItemLike)ModItems.DENSE_LEAD_PLATE), new Object[]{new ItemTagInput(IC2CExtrasTags.getForgeItemTag("ingots/lead"), 8)});
            r.addSimpleRecipe(CraftingRecipes.id("dense_iron_plate"), new ItemStack((ItemLike)ModItems.DENSE_IRON_PLATE), new Object[]{new ItemTagInput(IC2CExtrasTags.getForgeItemTag("ingots/iron"), 8)});
            if (IC2CExtrasConfig.EXTRA_NUCLEAR.get()) {
                r.addSimpleRecipe(CraftingRecipes.id("enriched_uranium_ingot"), new ItemStack((ItemLike)ModItems.ENRICHED_URANIUM_INGOT), new Object[]{ModItems.ENRICHED_URANIUM_FUEL});
                r.addSimpleRecipe(CraftingRecipes.id("mox_ingot"), new ItemStack((ItemLike)ModItems.MOX_INGOT), new Object[]{ModItems.MOX_FUEL});
                r.addSimpleRecipe(CraftingRecipes.id("plutonium_ingot"), new ItemStack((ItemLike)ModItems.PLUTONIUM_INGOT), new Object[]{IC2CExtrasTags.getForgeItemTag("dusts/plutonium")});
                r.addSimpleRecipe(CraftingRecipes.id("thorium_ingot"), new ItemStack((ItemLike)ModItems.THORIUM_INGOT), new Object[]{IC2CExtrasTags.getForgeItemTag("dusts/thorium")});
                r.addIC2SimpleRecipe("uranium_ingot", new ItemStack((ItemLike)IC2Items.INGOT_URANIUM), new Object[]{IC2CExtrasTags.getForgeItemTag("dusts/uranium")});
                r.addSimpleRecipe(CraftingRecipes.id("uranium_233_ingot"), new ItemStack((ItemLike)ModItems.URANIUM_233_INGOT), new Object[]{IC2CExtrasTags.getForgeItemTag("dusts/uranium233")});
                r.addSimpleRecipe(CraftingRecipes.id("uranium_235_ingot"), new ItemStack((ItemLike)ModItems.URANIUM_235_INGOT), new Object[]{IC2CExtrasTags.getForgeItemTag("dusts/uranium235")});
            }
            ORE_WASHING_PLANT.reload();
            THERMAL_CENTRIFUGE.reload();
        });
        ((GlobalRecipes)IC2.RECIPES.get((boolean)true)).enricher.registerListener(r -> {
            if (!IC2CExtrasConfig.DISABLE_NON_RADIATION.get() && IC2CExtrasConfig.EXTRA_NUCLEAR.get()) {
                r.removeRecipe(new ResourceLocation("ic2", "blaze"));
                r.removeRecipe(new ResourceLocation("ic2", "charcoal"));
                r.removeRecipe(new ResourceLocation("ic2", "ender"));
                r.removeRecipe(new ResourceLocation("ic2", "nether_star"));
                r.removeRecipe(new ResourceLocation("ic2", "redstone"));
                r.registerRecipe(EnrichRecipe.createIC2Recipe((Item)ModItems.ENRICHED_URANIUM_INGOT, (Item)Items.f_42585_, (int)200, (Item)IC2Items.INGOT_URANIUM_ENRICHED_BLAZE, (int)100, (int)ColorUtils.rgb((int)232, (int)155, (int)7, (int)255), (int)20, (String)"blaze"));
                Object2IntLinkedOpenHashMap inputs = new Object2IntLinkedOpenHashMap();
                inputs.put((Object)new ItemInput(Items.f_42414_), 25);
                inputs.put((Object)new ItemInput((ItemLike)IC2Blocks.CHARCOAL_BLOCK), 200);
                r.registerRecipe(EnrichRecipe.createIC2Recipe((Item)ModItems.ENRICHED_URANIUM_INGOT, (Object2IntMap)inputs, (Item)IC2Items.INGOT_URANIUM_ENRICHED_CHARCOAL, (int)100, (int)ColorUtils.rgb((int)54, (int)54, (int)54, (int)255), (int)5, (String)"charcoal"));
                r.registerRecipe(EnrichRecipe.createIC2Recipe((Item)ModItems.ENRICHED_URANIUM_INGOT, (Item)Items.f_42584_, (int)100, (Item)IC2Items.INGOT_URANIUM_ENRICHED_ENDERPEARL, (int)100, (int)ColorUtils.rgb((int)35, (int)174, (int)113, (int)255), (int)75, (String)"ender"));
                r.registerRecipe(EnrichRecipe.createIC2Recipe((Item)ModItems.ENRICHED_URANIUM_INGOT, (Item)Items.f_42686_, (int)200, (Item)IC2Items.INGOT_URANIUM_ENRICHED_NETHERSTAR, (int)150, (int)ColorUtils.rgb((int)255, (int)239, (int)106, (int)255), (int)150, (String)"nether_star"));
                inputs = new Object2IntLinkedOpenHashMap();
                inputs.put((Object)new ItemInput(Items.f_42451_), 25);
                inputs.put((Object)new ItemInput(Items.f_42153_), 200);
                r.registerRecipe(EnrichRecipe.createIC2Recipe((Item)ModItems.ENRICHED_URANIUM_INGOT, (Object2IntMap)inputs, (Item)IC2Items.INGOT_URANIUM_ENRICHED_REDSTONE, (int)100, (int)ColorUtils.RED, (int)25, (String)"redstone"));
            }
        });
        ((GlobalRecipes)IC2.RECIPES.get((boolean)true)).canner.registerListener(r -> {
            if (IC2CExtrasConfig.DISABLE_NON_RADIATION.get()) {
                return;
            }
            ArrayList addList = new ArrayList();
            if (r.getFillables().containsKey(new ItemStack((ItemLike)IC2Items.CELL_EMPTY))) {
                ((List)r.getFillables().get(new ItemStack((ItemLike)IC2Items.CELL_EMPTY))).stream().forEach(t -> {
                    if (((ItemStack)t.m_14419_()).m_41720_() != IC2Items.URANIUM_ROD_SINGLE) {
                        addList.add(t);
                    }
                });
            }
            r.removeFillable(new ItemStack((ItemLike)IC2Items.CELL_EMPTY));
            addList.forEach(t -> r.registerFillable(new ItemStack((ItemLike)IC2Items.CELL_EMPTY), (IInput)t.m_14418_(), (ItemStack)t.m_14419_()));
            ItemInput uranium = IC2CExtrasConfig.EXTRA_NUCLEAR.get() ? new ItemInput(ModItems.ENRICHED_URANIUM_INGOT) : new ItemTagInput(IC2Tags.INGOT_URANIUM);
            r.registerFillable(new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell()), (IInput)uranium, new ItemStack((ItemLike)IC2Items.URANIUM_ROD_SINGLE));
            if (!IC2.CONFIG.enableHardEnrichedUranium.get() && IC2CExtrasConfig.EMPTY_NUCLEAR_ROD.get()) {
                r.removeFillable(new ItemStack((ItemLike)IC2Items.CELL_EMPTY), new ItemStack((ItemLike)IC2Items.INGOT_URANIUM_ENRICHED_REDSTONE));
                r.registerFillable(new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell()), (IInput)new ItemInput(IC2Items.INGOT_URANIUM_ENRICHED_REDSTONE), new ItemStack((ItemLike)IC2Items.URANIUM_ROD_REDSTONE_SINGLE));
                r.removeFillable(new ItemStack((ItemLike)IC2Items.CELL_EMPTY), new ItemStack((ItemLike)IC2Items.INGOT_URANIUM_ENRICHED_BLAZE));
                r.registerFillable(new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell()), (IInput)new ItemInput(IC2Items.INGOT_URANIUM_ENRICHED_BLAZE), new ItemStack((ItemLike)IC2Items.URANIUM_ROD_BLAZE_SINGLE));
                r.removeFillable(new ItemStack((ItemLike)IC2Items.CELL_EMPTY), new ItemStack((ItemLike)IC2Items.INGOT_URANIUM_ENRICHED_CHARCOAL));
                r.registerFillable(new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell()), (IInput)new ItemInput(IC2Items.INGOT_URANIUM_ENRICHED_CHARCOAL), new ItemStack((ItemLike)IC2Items.URANIUM_ROD_CHARCOAL_SINGLE));
                r.removeFillable(new ItemStack((ItemLike)IC2Items.CELL_EMPTY), new ItemStack((ItemLike)IC2Items.INGOT_URANIUM_ENRICHED_NETHERSTAR));
                r.registerFillable(new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell()), (IInput)new ItemInput(IC2Items.INGOT_URANIUM_ENRICHED_NETHERSTAR), new ItemStack((ItemLike)IC2Items.URANIUM_ROD_NETHER_STAR_SINGLE));
                r.removeFillable(new ItemStack((ItemLike)IC2Items.CELL_EMPTY), new ItemStack((ItemLike)IC2Items.INGOT_URANIUM_ENRICHED_ENDERPEARL));
                r.registerFillable(new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell()), (IInput)new ItemInput(IC2Items.INGOT_URANIUM_ENRICHED_ENDERPEARL), new ItemStack((ItemLike)IC2Items.URANIUM_ROD_ENDER_PEARL_SINGLE));
            }
            if (IC2CExtrasConfig.EXTRA_NUCLEAR.get()) {
                IUraniumRod[] rods;
                for (IUraniumRod rod : rods = new IUraniumRod[]{Uranium238.INSTANCE, Uranium235.INSTANCE, Uranium233.INSTANCE, MOX.INSTANCE, Plutonium.INSTANCE, Thorium232.INSTANCE}) {
                    if (rod.isEnrichedUranium() && IC2.CONFIG.enableHardEnrichedUranium.get()) continue;
                    String tag = rod == Uranium238.INSTANCE ? "uranium" : rod.getName().replace("_", "");
                    r.registerFillable(new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell()), (IInput)new ItemTagInput(IC2CExtrasTags.getForgeItemTag("ingots/" + tag)), rod.createSingleRod());
                }
            }
        });
    }

    public static void initOreWasherRecipes(ExtendedRecipeList list) {
        ItemStack stoneDust = new ItemStack((ItemLike)ModItems.STONE_DUST);
        list.addOreWashingRecipe(CraftingRecipes.id("crushed_iron"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_IRON_ORE), new ItemStack((ItemLike)ModItems.TINY_IRON_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/iron"));
        list.addOreWashingRecipe(CraftingRecipes.id("crushed_gold"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_GOLD_ORE), new ItemStack((ItemLike)ModItems.TINY_GOLD_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/gold"));
        list.addOreWashingRecipe(CraftingRecipes.id("crushed_copper"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_COPPER_ORE), new ItemStack((ItemLike)ModItems.TINY_COPPER_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/copper"));
        list.addOreWashingRecipe(CraftingRecipes.id("crushed_tin"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_TIN_ORE), new ItemStack((ItemLike)ModItems.TINY_IRON_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/tin"));
        list.addOreWashingRecipe(CraftingRecipes.id("crushed_silver"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_SILVER_ORE), new ItemStack((ItemLike)ModItems.TINY_SILVER_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/silver"));
        list.addOreWashingRecipe(CraftingRecipes.id("crushed_lead"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_LEAD_ORE), new ItemStack((ItemLike)ModItems.TINY_LEAD_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/lead"));
        list.addOreWashingRecipe(CraftingRecipes.id("crushed_aluminium"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_ALUMINIUM_ORE), new ItemStack((ItemLike)ModItems.TINY_ALUMINIUM_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/aluminium"));
        if (IC2CExtrasConfig.EXTRA_NUCLEAR.get()) {
            list.addOreWashingRecipe(CraftingRecipes.id("crushed_uranium"), new ItemStack[]{new ItemStack((ItemLike)ModItems.PURIFIED_URANIUM_ORE), new ItemStack((ItemLike)ModItems.TINY_LEAD_DUST, 2), stoneDust}, 1000, IC2CExtrasTags.getForgeItemTag("crushed_ores/uranium"));
        }
    }

    public static void initThermalCentrifugeRecipes(ExtendedRecipeList list) {
        list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_iron"), new ItemStack[]{new ItemStack((ItemLike)IC2Items.DUST_IRON), new ItemStack((ItemLike)ModItems.TINY_TIN_DUST, 1)}, 400, 250, IC2CExtrasTags.getForgeItemTag("purified_ores/iron"));
        list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_gold"), new ItemStack[]{new ItemStack((ItemLike)IC2Items.DUST_GOLD), new ItemStack((ItemLike)ModItems.TINY_IRON_DUST, 1)}, 400, 250, IC2CExtrasTags.getForgeItemTag("purified_ores/gold"));
        list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_copper"), new ItemStack[]{new ItemStack((ItemLike)IC2Items.DUST_COPPER), new ItemStack((ItemLike)ModItems.TINY_GOLD_DUST, 1)}, 400, 250, IC2CExtrasTags.getForgeItemTag("purified_ores/copper"));
        list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_tin"), new ItemStack[]{new ItemStack((ItemLike)IC2Items.DUST_TIN), new ItemStack((ItemLike)ModItems.TINY_TIN_DUST, 1)}, 400, 250, IC2CExtrasTags.getForgeItemTag("purified_ores/tin"));
        list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_silver"), new ItemStack[]{new ItemStack((ItemLike)IC2Items.DUST_SILVER), new ItemStack((ItemLike)ModItems.TINY_LEAD_DUST, 1)}, 400, 250, IC2CExtrasTags.getForgeItemTag("purified_ores/silver"));
        list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_lead"), new ItemStack[]{new ItemStack((ItemLike)ModItems.LEAD_DUST), new ItemStack((ItemLike)ModItems.TINY_SILVER_DUST, 1)}, 400, 250, IC2CExtrasTags.getForgeItemTag("purified_ores/lead"));
        list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_aluminium"), new ItemStack[]{new ItemStack((ItemLike)IC2Items.DUST_ALUMINIUM), new ItemStack((ItemLike)ModItems.TINY_IRON_DUST, 1)}, 400, 250, IC2CExtrasTags.getForgeItemTag("purified_ores/aluminium"));
        if (IC2CExtrasConfig.EXTRA_NUCLEAR.get()) {
            list.addThermalCentrifugingRecipe(CraftingRecipes.id("purified_uranium"), new ItemStack[]{new ItemStack((ItemLike)ModItems.REFINED_URANIUM_ORE), new ItemStack((ItemLike)ModItems.TINY_THORIUM_DUST, 1)}, 900, 375, IC2CExtrasTags.getForgeItemTag("purified_ores/uranium"));
            list.addThermalCentrifugingRecipe(CraftingRecipes.id("refined_uranium"), new ItemStack[]{new ItemStack((ItemLike)ModItems.URANIUM_DUST, 2), new ItemStack((ItemLike)ModItems.TINY_URANIUM_235_DUST, 1)}, 900, 375, IC2CExtrasTags.getForgeItemTag("refined_ores/uranium"));
            list.addThermalCentrifugingRecipe(CraftingRecipes.id("re_enriched_uranium_cell"), new ItemStack[]{new ItemStack((ItemLike)ModItems.TINY_PLUTONIUM_DUST), new ItemStack((ItemLike)ModItems.TINY_THORIUM_DUST, 2), new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell())}, 1500, 750, IC2Items.URANIUM_ROD_RE_ENRICHED);
            list.addThermalCentrifugingRecipe(CraftingRecipes.id("re_enriched_uranium_238_cell"), new ItemStack[]{new ItemStack((ItemLike)ModItems.TINY_PLUTONIUM_DUST, 2), new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell())}, 1500, 750, ModItems.RE_ENRICHED_URANIUM_238_ROD);
            list.addThermalCentrifugingRecipe(CraftingRecipes.id("re_enriched_thorium_cell"), new ItemStack[]{new ItemStack((ItemLike)ModItems.TINY_URANIUM_233_DUST, 2), new ItemStack((ItemLike)CraftingRecipes.getEmptyNuclearCell())}, 1500, 750, ModItems.RE_ENRICHED_THORIUM_ROD);
        }
    }

    public static void initMaceratorRecipes(IMachineRecipeList list) {
        if (IC2CExtrasConfig.DISABLE_NON_RADIATION.get()) {
            return;
        }
        list.addIC2XPRecipe("iron_ore_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_IRON_ORE, 2), 0.7f, new Object[]{Tags.Items.ORES_IRON});
        list.addIC2XPRecipe("gold_ore_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_GOLD_ORE, 2), 1.0f, new Object[]{Tags.Items.ORES_GOLD});
        list.addIC2XPRecipe("copper_ore_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_COPPER_ORE, 2), 0.3f, new Object[]{IC2Tags.ORE_COPPER});
        list.addIC2XPRecipe("tin_ore_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_TIN_ORE, 2), 0.4f, new Object[]{IC2Tags.ORE_TIN});
        list.addIC2XPRecipe("silver_ore_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_SILVER_ORE, 2), 0.8f, new Object[]{IC2Tags.ORE_SILVER});
        list.addXPRecipe(CraftingRecipes.id("lead_ore_to_crushed"), new ItemStack((ItemLike)ModItems.CRUSHED_LEAD_ORE, 2), 0.8f, new Object[]{IC2CExtrasTags.LEAD_ORE});
        list.addIC2XPRecipe("aluminum_ore_nether_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_ALUMINIUM_ORE, 2), 1.0f, new Object[]{IC2Tags.ORE_ALUMINIUM});
        list.addIC2XPRecipe("raw_iron_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_IRON_ORE, 2), 0.7f, new Object[]{Tags.Items.RAW_MATERIALS_IRON});
        list.addIC2XPRecipe("raw_gold_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_GOLD_ORE, 2), 1.0f, new Object[]{Tags.Items.RAW_MATERIALS_GOLD});
        list.addIC2XPRecipe("raw_copper_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_COPPER_ORE, 2), 0.3f, new Object[]{Tags.Items.RAW_MATERIALS_COPPER});
        list.addIC2XPRecipe("raw_tin_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_TIN_ORE, 2), 0.4f, new Object[]{IC2Tags.RAW_TIN});
        list.addIC2XPRecipe("raw_silver_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_SILVER_ORE, 2), 0.8f, new Object[]{IC2Tags.RAW_SILVER});
        list.addXPRecipe(CraftingRecipes.id("raw_lead_to_crushed"), new ItemStack((ItemLike)ModItems.CRUSHED_LEAD_ORE, 2), 0.8f, new Object[]{IC2CExtrasTags.RAW_LEAD});
        list.addIC2XPRecipe("raw_aluminum_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_ALUMINIUM_ORE, 2), 1.0f, new Object[]{IC2Tags.RAW_ALUMINIUM});
        list.addIC2XPRecipe("raw_iron_block_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_IRON_ORE, 18), 6.3f, RecipeMods.RECIPE_TIME.create(4.0), new Object[]{Tags.Items.STORAGE_BLOCKS_RAW_IRON});
        list.addIC2XPRecipe("raw_gold_block_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_GOLD_ORE, 18), 9.0f, RecipeMods.RECIPE_TIME.create(4.0), new Object[]{Tags.Items.STORAGE_BLOCKS_RAW_GOLD});
        list.addIC2XPRecipe("raw_copper_block_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_COPPER_ORE, 18), 2.7f, RecipeMods.RECIPE_TIME.create(4.0), new Object[]{Tags.Items.STORAGE_BLOCKS_RAW_COPPER});
        list.addIC2XPRecipe("raw_tin_block_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_TIN_ORE, 18), 3.6f, RecipeMods.RECIPE_TIME.create(4.0), new Object[]{IC2Tags.STORAGE_RAW_TIN});
        list.addIC2XPRecipe("raw_silver_block_to_dust", new ItemStack((ItemLike)ModItems.CRUSHED_SILVER_ORE, 18), 7.2f, RecipeMods.RECIPE_TIME.create(4.0), new Object[]{IC2Tags.STORAGE_RAW_SILVER});
        list.addXPRecipe(CraftingRecipes.id("raw_lead_block_to_crushed"), new ItemStack((ItemLike)ModItems.CRUSHED_LEAD_ORE, 18), 7.2f, RecipeMods.RECIPE_TIME.create(4.0), new Object[]{IC2CExtrasTags.RAW_LEAD_BLOCK});
        list.addIC2XPRecipe("raw_aluminum_block_to_dust", new ItemStack((ItemLike)IC2Items.DUST_ALUMINIUM, 18), 9.0f, RecipeMods.RECIPE_TIME.create(4.0), new Object[]{IC2Tags.STORAGE_RAW_ALUMINIUM});
        if (IC2CExtrasConfig.EXTRA_NUCLEAR.get()) {
            list.addXPRecipe(CraftingRecipes.id("uranium_ore_to_crushed"), new ItemStack((ItemLike)ModItems.CRUSHED_URANIUM_ORE, 2), 0.9f, new Object[]{IC2Tags.ORE_URANIUM});
            list.addXPRecipe(CraftingRecipes.id("raw_uranium_to_crushed"), new ItemStack((ItemLike)ModItems.CRUSHED_URANIUM_ORE, 2), 0.9f, new Object[]{IC2Tags.RAW_URANIUM});
            list.addXPRecipe(CraftingRecipes.id("raw_uranium_block_to_crushed"), new ItemStack((ItemLike)ModItems.CRUSHED_URANIUM_ORE, 18), 8.1f, new Object[]{IC2Tags.STORAGE_RAW_URANIUM});
        }
    }
}

