/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.event.ServerEvents;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageDragonControl {
    public int dragonId;
    public byte controlState;
    public int armor_type;
    private double posX;
    private double posY;
    private double posZ;

    public MessageDragonControl(int dragonId, byte controlState, double posX, double posY, double posZ) {
        this.dragonId = dragonId;
        this.controlState = controlState;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public MessageDragonControl() {
    }

    public static MessageDragonControl read(FriendlyByteBuf buf) {
        return new MessageDragonControl(buf.readInt(), buf.readByte(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void write(MessageDragonControl message, FriendlyByteBuf buf) {
        buf.writeInt(message.dragonId);
        buf.writeByte((int)message.controlState);
        buf.writeDouble(message.posX);
        buf.writeDouble(message.posY);
        buf.writeDouble(message.posZ);
    }

    private double getPosX() {
        return this.posX;
    }

    private double getPosY() {
        return this.posY;
    }

    private double getPosZ() {
        return this.posZ;
    }

    public static class Handler {
        public static void handle(MessageDragonControl message, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayer player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.f_19853_ != null && ServerEvents.isRidingOrBeingRiddenBy(entity = player.f_19853_.m_6815_(message.dragonId), (Entity)player)) {
                EntityAmphithere amphi;
                if (entity != null && entity instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)entity;
                    if (dragon.m_21830_((LivingEntity)player)) {
                        dragon.setControlState(message.controlState);
                    }
                } else if (entity instanceof EntityHippogryph) {
                    EntityHippogryph hippo = (EntityHippogryph)entity;
                    if (hippo.m_21830_((LivingEntity)player)) {
                        hippo.setControlState(message.controlState);
                    }
                } else if (entity instanceof EntityHippocampus) {
                    EntityHippocampus hippo = (EntityHippocampus)entity;
                    if (hippo.m_21830_((LivingEntity)player)) {
                        hippo.setControlState(message.controlState);
                    }
                } else if (entity instanceof EntityDeathWorm) {
                    EntityDeathWorm deathworm = (EntityDeathWorm)entity;
                    deathworm.setControlState(message.controlState);
                    deathworm.m_6034_(message.getPosX(), message.getPosY(), message.getPosZ());
                } else if (entity instanceof EntityAmphithere && (amphi = (EntityAmphithere)entity).m_21830_((LivingEntity)player)) {
                    amphi.setControlState(message.controlState);
                }
            }
        }
    }
}

