/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityLectern;
import com.github.alexthe666.iceandfire.enums.EnumBestiaryPages;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdateLectern {
    public long blockPos;
    public int selectedPages1;
    public int selectedPages2;
    public int selectedPages3;
    public boolean updateStack;
    public int pageOrdinal;

    public MessageUpdateLectern(long blockPos, int selectedPages1, int selectedPages2, int selectedPages3, boolean updateStack, int pageOrdinal) {
        this.blockPos = blockPos;
        this.selectedPages1 = selectedPages1;
        this.selectedPages2 = selectedPages2;
        this.selectedPages3 = selectedPages3;
        this.updateStack = updateStack;
        this.pageOrdinal = pageOrdinal;
    }

    public MessageUpdateLectern() {
    }

    public static MessageUpdateLectern read(FriendlyByteBuf buf) {
        return new MessageUpdateLectern(buf.readLong(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readInt());
    }

    public static void write(MessageUpdateLectern message, FriendlyByteBuf buf) {
        buf.writeLong(message.blockPos);
        buf.writeInt(message.selectedPages1);
        buf.writeInt(message.selectedPages2);
        buf.writeInt(message.selectedPages3);
        buf.writeBoolean(message.updateStack);
        buf.writeInt(message.pageOrdinal);
    }

    public static class Handler {
        public static void handle(MessageUpdateLectern message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> Handler.lambda$handle$1(message, (Supplier)ctx)));
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$4(message, (Supplier)ctx)));
            ctx.get().setPacketHandled(true);
        }

        public static void handlePacket(MessageUpdateLectern message, Supplier<NetworkEvent.Context> context) {
            BlockEntity blockEntity;
            BlockPos pos;
            context.get().setPacketHandled(true);
            ServerPlayer player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.f_19853_ != null && player.f_19853_.m_46805_(pos = BlockPos.m_122022_((long)message.blockPos)) && (blockEntity = player.f_19853_.m_7702_(pos)) instanceof TileEntityLectern) {
                TileEntityLectern lectern = (TileEntityLectern)blockEntity;
                if (message.updateStack) {
                    ItemStack bookStack = lectern.m_8020_(0);
                    if (bookStack.m_41720_() == IafItemRegistry.BESTIARY.get()) {
                        EnumBestiaryPages.addPage(EnumBestiaryPages.fromInt(message.pageOrdinal), bookStack);
                    }
                    lectern.randomizePages(bookStack, lectern.m_8020_(1));
                } else {
                    lectern.selectedPages[0] = EnumBestiaryPages.fromInt(message.selectedPages1);
                    lectern.selectedPages[1] = EnumBestiaryPages.fromInt(message.selectedPages2);
                    lectern.selectedPages[2] = EnumBestiaryPages.fromInt(message.selectedPages3);
                }
            }
        }

        private static /* synthetic */ Runnable lambda$handle$4(MessageUpdateLectern message, Supplier ctx) {
            return () -> Handler.lambda$handle$3(message, (Supplier)ctx);
        }

        private static /* synthetic */ void lambda$handle$3(MessageUpdateLectern message, Supplier ctx) {
            Handler.handlePacket(message, ctx);
        }

        private static /* synthetic */ Runnable lambda$handle$1(MessageUpdateLectern message, Supplier ctx) {
            return () -> Handler.lambda$handle$0(message, (Supplier)ctx);
        }

        private static /* synthetic */ void lambda$handle$0(MessageUpdateLectern message, Supplier ctx) {
            Handler.handlePacket(message, ctx);
        }
    }
}

