/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdatePixieHouse {
    public long blockPos;
    public boolean hasPixie;
    public int pixieType;

    public MessageUpdatePixieHouse(long blockPos, boolean hasPixie, int pixieType) {
        this.blockPos = blockPos;
        this.hasPixie = hasPixie;
        this.pixieType = pixieType;
    }

    public MessageUpdatePixieHouse() {
    }

    public static MessageUpdatePixieHouse read(FriendlyByteBuf buf) {
        return new MessageUpdatePixieHouse(buf.readLong(), buf.readBoolean(), buf.readInt());
    }

    public static void write(MessageUpdatePixieHouse message, FriendlyByteBuf buf) {
        buf.writeLong(message.blockPos);
        buf.writeBoolean(message.hasPixie);
        buf.writeInt(message.pixieType);
    }

    public static class Handler {
        public static void handle(MessageUpdatePixieHouse message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            ServerPlayer player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.f_19853_ != null) {
                BlockEntity blockEntity;
                BlockPos pos = BlockPos.m_122022_((long)message.blockPos);
                if (player.f_19853_.m_7702_(pos) != null && (blockEntity = player.f_19853_.m_7702_(pos)) instanceof TileEntityPixieHouse) {
                    TileEntityPixieHouse house = (TileEntityPixieHouse)blockEntity;
                    house.hasPixie = message.hasPixie;
                    house.pixieType = message.pixieType;
                } else if (player.f_19853_.m_7702_(pos) != null && (blockEntity = player.f_19853_.m_7702_(pos)) instanceof TileEntityJar) {
                    TileEntityJar jar = (TileEntityJar)blockEntity;
                    jar.hasPixie = message.hasPixie;
                    jar.pixieType = message.pixieType;
                }
            }
        }
    }
}

