/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.integration.clothconfig;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.configbuilder.entry.AbstractConfigEntry;
import de.maxhenkel.voicechat.configbuilder.entry.BooleanConfigEntry;
import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.configbuilder.entry.DoubleConfigEntry;
import de.maxhenkel.voicechat.configbuilder.entry.IntegerConfigEntry;
import de.maxhenkel.voicechat.configbuilder.entry.StringConfigEntry;
import de.maxhenkel.voicechat.integration.freecam.FreecamMode;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ClothConfigIntegration {
    public static final MutableComponent SETTINGS = Component.m_237115_((String)"cloth_config.voicechat.settings");
    public static final MutableComponent OTHER_SETTINGS = Component.m_237115_((String)"cloth_config.voicechat.category.ingame_menu");

    public static Screen createConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)SETTINGS);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.m_237115_((String)"cloth_config.voicechat.category.general"));
        general.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.recordingDestination));
        general.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.runLocalServer));
        general.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.offlinePlayerVolumeAdjustment));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.m_237115_((String)"cloth_config.voicechat.config.freecam_mode"), FreecamMode.class, (Enum)VoicechatClient.CLIENT_CONFIG.freecamMode.get()).setEnumNameProvider(e -> Component.m_237115_((String)String.format("cloth_config.voicechat.config.freecam_mode.%s", e.name().toLowerCase()))).setTooltip(new Component[]{Component.m_237115_((String)"cloth_config.voicechat.config.freecam_mode.description")}).setDefaultValue(VoicechatClient.CLIENT_CONFIG.freecamMode::getDefault).setSaveConsumer(e -> VoicechatClient.CLIENT_CONFIG.freecamMode.set((FreecamMode)((Object)e)).save()).build());
        general.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.muteOnJoin));
        ConfigCategory audio = builder.getOrCreateCategory((Component)Component.m_237115_((String)"cloth_config.voicechat.category.audio"));
        audio.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.audioPacketThreshold));
        audio.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.deactivationDelay));
        audio.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.outputBufferSize));
        ConfigCategory hudIcons = builder.getOrCreateCategory((Component)Component.m_237115_((String)"cloth_config.voicechat.category.hud_icons"));
        hudIcons.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.hudIconScale));
        hudIcons.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.hudIconPosX));
        hudIcons.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.hudIconPosY));
        ConfigCategory groupIcons = builder.getOrCreateCategory((Component)Component.m_237115_((String)"cloth_config.voicechat.category.group_chat_icons"));
        groupIcons.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.m_237115_((String)"cloth_config.voicechat.config.group_player_icon_orientation"), GroupPlayerIconOrientation.class, (Enum)VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get()).setEnumNameProvider(e -> Component.m_237115_((String)String.format("cloth_config.voicechat.config.group_player_icon_orientation.%s", e.name().toLowerCase()))).setTooltip(new Component[]{Component.m_237115_((String)"cloth_config.voicechat.config.group_player_icon_orientation.description")}).setDefaultValue(VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation::getDefault).setSaveConsumer(e -> VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.set((GroupPlayerIconOrientation)((Object)e)).save()).build());
        groupIcons.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.groupHudIconScale));
        groupIcons.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX));
        groupIcons.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY));
        groupIcons.addEntry(ClothConfigIntegration.fromConfigEntry(entryBuilder, VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon));
        builder.getOrCreateCategory((Component)OTHER_SETTINGS);
        return builder.build();
    }

    protected static <T> AbstractConfigListEntry<T> fromConfigEntry(ConfigEntryBuilder entryBuilder, ConfigEntry<T> entry) {
        MutableComponent name = Component.m_237115_((String)String.format("cloth_config.voicechat.config.%s", entry.getKey()));
        MutableComponent description = Component.m_237115_((String)String.format("cloth_config.voicechat.config.%s.description", entry.getKey()));
        if (entry instanceof DoubleConfigEntry) {
            DoubleConfigEntry e = (DoubleConfigEntry)entry;
            return entryBuilder.startDoubleField((Component)name, ((Double)e.get()).doubleValue()).setTooltip(new Component[]{description}).setMin(((Double)e.getMin()).doubleValue()).setMax(((Double)e.getMax()).doubleValue()).setDefaultValue(e::getDefault).setSaveConsumer(d -> {
                e.set(d);
                e.save();
            }).build();
        }
        if (entry instanceof IntegerConfigEntry) {
            IntegerConfigEntry e = (IntegerConfigEntry)entry;
            return entryBuilder.startIntField((Component)name, ((Integer)e.get()).intValue()).setTooltip(new Component[]{description}).setMin(((Integer)e.getMin()).intValue()).setMax(((Integer)e.getMax()).intValue()).setDefaultValue(e::getDefault).setSaveConsumer(d -> ((AbstractConfigEntry)e.set(d)).save()).build();
        }
        if (entry instanceof BooleanConfigEntry) {
            BooleanConfigEntry e = (BooleanConfigEntry)entry;
            return entryBuilder.startBooleanToggle((Component)name, ((Boolean)e.get()).booleanValue()).setTooltip(new Component[]{description}).setDefaultValue(e::getDefault).setSaveConsumer(d -> ((AbstractConfigEntry)e.set(d)).save()).build();
        }
        if (entry instanceof StringConfigEntry) {
            StringConfigEntry e = (StringConfigEntry)entry;
            return entryBuilder.startStrField((Component)name, (String)e.get()).setTooltip(new Component[]{description}).setDefaultValue(e::getDefault).setSaveConsumer(d -> ((AbstractConfigEntry)e.set(d)).save()).build();
        }
        throw new IllegalArgumentException("Unknown config entry type %s".formatted(entry.getClass().getName()));
    }
}

