/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.bookmarks;

import java.util.Objects;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.IngredientBookmarkElement;

public class IngredientBookmark<T>
implements IBookmark {
    private final IElement<T> element;
    private final String uid;
    private final ITypedIngredient<T> typedIngredient;
    private boolean visible = true;

    public static <T> IngredientBookmark<T> create(ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager) {
        IIngredientType<T> type = typedIngredient.getType();
        typedIngredient = ingredientManager.normalizeTypedIngredient(typedIngredient);
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(type);
        String uniqueId = ingredientHelper.getUniqueId(typedIngredient.getIngredient(), UidContext.Ingredient);
        return new IngredientBookmark<T>(typedIngredient, uniqueId);
    }

    private IngredientBookmark(ITypedIngredient<T> typedIngredient, String uid) {
        this.typedIngredient = typedIngredient;
        this.uid = uid;
        this.element = new IngredientBookmarkElement(this);
    }

    public ITypedIngredient<T> getIngredient() {
        return this.typedIngredient;
    }

    @Override
    public IElement<?> getElement() {
        return this.element;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.typedIngredient.getType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IngredientBookmark) {
            IngredientBookmark ingredientBookmark = (IngredientBookmark)obj;
            return ingredientBookmark.uid.equals(this.uid) && ingredientBookmark.typedIngredient.getType().equals(this.typedIngredient.getType());
        }
        return false;
    }

    public String toString() {
        return "IngredientBookmark{uid=" + this.uid + ", typedIngredient=" + this.typedIngredient + ", visible=" + this.visible + "}";
    }
}

