/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.item.container;

import ic2.core.block.transport.item.components.RequestTubeComponent;
import ic2.core.block.transport.item.tubes.RequestTubeTileEntity;
import ic2.core.inventory.container.ContainerComponent;
import ic2.core.inventory.filter.SpecialFilters;
import ic2.core.inventory.gui.IC2Screen;
import ic2.core.inventory.gui.components.simple.FilterComponent;
import ic2.core.inventory.inv.SimpleInventory;
import ic2.core.inventory.slot.GhostSlot;
import ic2.core.inventory.slot.LockedSlot;
import ic2.core.utils.helpers.StackUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RequestTubeContainer
extends ContainerComponent<RequestTubeTileEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("ic2", "textures/gui_sprites/tubes/gui_requester_tube.png");

    public RequestTubeContainer(RequestTubeTileEntity key, Player player, int id) {
        super(key, player, id);
        SimpleInventory inv = new SimpleInventory(18);
        this.m_38897_(new GhostSlot(key.filterInv, 0, 62, 78, SpecialFilters.NO_TAGS));
        for (int i = 0; i < 18; ++i) {
            int xPos = i % 9;
            int yPos = i / 9;
            this.m_38897_(new LockedSlot(inv, i, 8 + xPos * 18, 17 + yPos * 18));
        }
        this.addPlayerInventoryWithOffset(player.m_150109_(), 0, 16);
        this.addComponent(new RequestTubeComponent(key, inv));
        this.addComponent(new FilterComponent(this.getInventoryOffset()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onGuiLoaded(IC2Screen screen) {
        screen.setMaxSize(177, 182);
        screen.setFlag(4);
    }

    @Override
    public int getInventorySize() {
        return 0;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == 0) {
            ItemStack stack = this.m_142621_();
            ((RequestTubeTileEntity)this.getHolder()).filterInv.setStackInSlot(slotId, stack.m_41619_() ? ItemStack.f_41583_ : StackUtil.copyWithSize(stack, 1));
            return;
        }
        if (slotId >= 1 && slotId < 19) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

