/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.core.item.base.IC2TexturedBlockItem;
import ic2.core.item.food_and_drink.drinks.Beer;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registries.IC2Blocks;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.platform.rendering.features.item.IItemModel;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.IAdvancedTooltip;
import ic2.core.utils.tooltips.ILangHelper;
import ic2.core.utils.tooltips.ToolTipHelper;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class BarrelItem
extends IC2TexturedBlockItem
implements IItemModel,
IAdvancedTooltip,
ILangHelper {
    public BarrelItem(Block block) {
        super(block, "food_and_drink", "barrel");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addToolTip(ItemStack stack, Player player, TooltipFlag flag, ToolTipHelper helper) {
        if (PlayerHandler.getClientHandler().hasThermometer()) {
            CompoundTag tag = StackUtil.getNbtData(stack);
            int type = tag.m_128451_("type");
            int data = tag.m_128451_("data");
            switch (type) {
                case 1: {
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.type.beer").m_130940_(ChatFormatting.GOLD));
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.water.stored", new Object[]{Formatters.EU_FORMAT.format(tag.m_128451_("fluid"))}).m_130940_(ChatFormatting.BLUE));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.beer.quality." + Beer.getTime(data) + ".name").m_130940_(ChatFormatting.AQUA));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.beer.alc." + Beer.getHops(data) + ".name").m_130940_(ChatFormatting.GREEN));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.beer.solid." + Beer.getSolid(data) + ".name").m_130940_(ChatFormatting.YELLOW));
                    helper.addDataTooltip(this.translate("ic2.probe.barrel.beer.hops.name", new Object[]{tag.m_128451_("hops")}).m_130940_(ChatFormatting.GREEN));
                    helper.addDataTooltip(this.translate("ic2.probe.barrel.beer.wheat.name", new Object[]{tag.m_128451_("wheat")}).m_130940_(ChatFormatting.YELLOW));
                    break;
                }
                case 2: {
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.type.rum").m_130940_(ChatFormatting.GOLD));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.beer.sugar_cane.name", new Object[]{tag.m_128451_("fluid") / 1000}).m_130940_(ChatFormatting.GREEN));
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.rum.progress", new Object[]{data + "%"}).m_130940_(ChatFormatting.AQUA));
                    break;
                }
                case 5: {
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.type.whisky").m_130940_(ChatFormatting.GOLD));
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.water.stored", new Object[]{Formatters.EU_FORMAT.format(tag.m_128451_("fluid"))}).m_130940_(ChatFormatting.BLUE));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.whisky.grist.name", new Object[]{tag.m_128451_("hops")}).m_130940_(ChatFormatting.GREEN));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.whisky.years.name", new Object[]{data}).m_130940_(ChatFormatting.DARK_AQUA));
                    break;
                }
                case 10: {
                    MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(tag.m_128461_("potion")));
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.type.potion").m_130940_(ChatFormatting.GOLD));
                    helper.addSimpleToolTip(this.translate("tooltip.block.ic2.barrel.water.stored", new Object[]{Formatters.EU_FORMAT.format(tag.m_128451_("fluid"))}).m_130940_(ChatFormatting.BLUE));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.status.output.name", new Object[]{effect == null ? this.translate("tooltip.block.ic2.barrel.unknown") : effect.m_19482_()}).m_130940_(ChatFormatting.GREEN));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.potion.quality." + tag.m_128451_("quality") + ".name").m_130940_(ChatFormatting.AQUA));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.beer.glowstone.name", new Object[]{tag.m_128451_("red")}).m_130940_(ChatFormatting.YELLOW));
                    helper.addSimpleToolTip(this.translate("ic2.probe.barrel.beer.redstone.name", new Object[]{tag.m_128451_("glow")}).m_130940_(ChatFormatting.RED));
                    break;
                }
            }
        }
    }

    @Override
    public int getModelIndexForStack(ItemStack stack, LivingEntity entity) {
        switch (StackUtil.getNbtData(stack).m_128451_("type")) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 10: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public List<ItemStack> getModelTypes() {
        ObjectList items = CollectionUtils.createList();
        items.add((ItemStack)this.create(1));
        items.add((ItemStack)this.create(2));
        items.add((ItemStack)this.create(5));
        items.add((ItemStack)this.create(10));
        return items;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getSprite(ItemStack input) {
        switch (StackUtil.getNbtData(input).m_128451_("type")) {
            case 1: {
                return IC2Textures.getMappedEntriesItem(this.id.m_135827_(), "food_and_drink/barrel").get("beer");
            }
            case 2: {
                return IC2Textures.getMappedEntriesItem(this.id.m_135827_(), "food_and_drink/barrel").get("rum");
            }
            case 5: {
                return IC2Textures.getMappedEntriesItem(this.id.m_135827_(), "food_and_drink/barrel").get("whisky");
            }
            case 10: {
                return IC2Textures.getMappedEntriesItem(this.id.m_135827_(), "food_and_drink/barrel").get("potion");
            }
        }
        return this.getTexture();
    }

    private ItemStack create(int type) {
        ItemStack stack = new ItemStack((ItemLike)IC2Blocks.BARREL);
        stack.m_41700_("type", (Tag)IntTag.m_128679_((int)type));
        return stack;
    }
}

