/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.elements;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.impl.ui.ProgressStyle;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;

public class CustomProgressStyle
extends ProgressStyle {
    public void render(PoseStack matrixStack, float x, float y, float width, float height, float progress, Component text) {
        int color;
        progress *= this.choose(true, width, height);
        float progressY = y;
        if (this.vertical) {
            progressY = y + (height - progress);
        }
        if (progress > 0.0f) {
            if (this.overlay != null) {
                Vec2 size = new Vec2(this.choose(true, progress, width), this.choose(false, progress, height));
                this.overlay.size(size);
                this.overlay.render(matrixStack, x, progressY, size.f_82470_, size.f_82471_);
            } else {
                int alpha = (int)((float)(this.color >> 24 & 0xFF) * 0.7f);
                color = this.color & 0xFFFFFF | alpha << 24;
                float half = this.choose(true, height, width) / 2.0f;
                DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, progressY, this.choose(true, progress, half), this.choose(false, progress, half), color, this.color, this.vertical);
                DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + this.choose(false, half, 0.0f), progressY + this.choose(true, half, 0.0f), this.choose(true, progress, half), this.choose(false, progress, half), this.color, color, this.vertical);
                if (this.color != this.color2) {
                    if (this.vertical) {
                        for (float yy = y + height; yy > progressY; yy -= 2.0f) {
                            float fy = Math.max(progressY, yy + 1.0f);
                            DisplayHelper.fill((PoseStack)matrixStack, (float)x, (float)yy, (float)(x + width), (float)fy, (int)this.color2);
                        }
                    } else {
                        for (float yy = x + 1.0f; yy < x + progress; yy += 2.0f) {
                            float fy = Math.min(x + width, yy + 1.0f);
                            DisplayHelper.fill((PoseStack)matrixStack, (float)yy, (float)y, (float)fy, (float)(y + height), (int)this.color2);
                        }
                    }
                }
            }
        }
        if (text != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            if (this.autoTextColor) {
                this.autoTextColor = false;
                this.textColor = this.overlay == null && CustomProgressStyle.RGBtoHSV(this.color2).m_122269_() > 0.75f ? -16777216 : -1;
            }
            Objects.requireNonNull(font);
            y += height - 9.0f;
            if (this.vertical) {
                Objects.requireNonNull(font);
                if (9.0f < progress) {
                    y -= progress;
                    Objects.requireNonNull(font);
                    y += 11.0f;
                }
            }
            color = IWailaConfig.IConfigOverlay.applyAlpha((int)this.textColor, (float)OverlayRenderer.alpha);
            if (this.glowText) {
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_168645_(text.m_7532_(), x + 1.0f, y, -1, -13421773, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0);
                multibuffersource$buffersource.m_109911_();
            } else if (this.shadow) {
                font.m_92763_(matrixStack, text, x + 1.0f, y, color);
            } else {
                font.m_92889_(matrixStack, text, x + 1.0f, y, color);
            }
        }
    }

    private float choose(boolean expand, float x, float y) {
        return this.vertical ^ expand ? x : y;
    }

    private static Vector3f RGBtoHSV(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int max = Math.max(r, Math.max(g, b));
        int min = Math.min(r, Math.min(g, b));
        float v = max;
        float delta = max - min;
        if (max != 0) {
            float s = delta / (float)max;
            float h = r == max ? (float)(g - b) / delta : (g == max ? 2.0f + (float)(b - r) / delta : 4.0f + (float)(r - g) / delta);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
            return new Vector3f(h, s, v / 255.0f);
        }
        float s = 0.0f;
        float h = -1.0f;
        return new Vector3f(h, s, 0.0f);
    }
}

