/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.helpers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import ic2.core.block.transport.fluid.graph.FluidNet;
import ic2.core.block.transport.fluid.graph.IFluidPipe;
import ic2.core.utils.collection.LongAverager;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.material.Fluid;

public class FluidContainer {
    static final Cache<BlockPos, FluidContainer> CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).maximumSize(128L).build();
    Object2LongMap<Fluid> lastFluids = new Object2LongOpenHashMap();
    Map<Fluid, LongAverager> averages = new Object2ObjectLinkedOpenHashMap();
    long lastTimeIn = -1L;

    public static FluidContainer getContainer(IFluidPipe tile) {
        FluidContainer result = (FluidContainer)CACHE.getIfPresent((Object)tile.getPosition());
        if (result == null) {
            result = new FluidContainer();
            CACHE.put((Object)tile.getPosition(), (Object)result);
        }
        result.process(tile);
        return result;
    }

    public void process(IFluidPipe pipe) {
        long currentTime = pipe.getWorldObj().m_46467_();
        FluidNet.TransportStats stats = FluidNet.INSTANCE.getStats(pipe);
        if (this.lastTimeIn == -1L) {
            this.lastFluids.putAll((Map)stats.getTransfered());
            this.lastTimeIn = currentTime;
            return;
        }
        double diff = currentTime - this.lastTimeIn;
        if (diff <= 0.0) {
            return;
        }
        this.lastTimeIn = currentTime;
        for (Object2LongMap.Entry entry : stats.getTransfered().object2LongEntrySet()) {
            Fluid fluid = (Fluid)entry.getKey();
            long current = entry.getLongValue();
            this.averages.computeIfAbsent(fluid, T -> new LongAverager(20)).addEntry((long)((int)((double)(current - this.lastFluids.getLong((Object)fluid)) / diff)));
            this.lastFluids.put((Object)fluid, current);
        }
    }

    public int getAverage(Fluid fluid) {
        LongAverager avg = this.averages.get(fluid);
        return avg == null ? 0 : (int)avg.getAverage();
    }
}

