/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.helpers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Formatter {
    public static final DecimalFormatSymbols US = new DecimalFormatSymbols(Locale.US);
    public static final DecimalFormat THERMAL_GEN = new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.US));
    public static final DecimalFormat SOLAR_TURBINE = new DecimalFormat("#00.00", new DecimalFormatSymbols(Locale.US));
    public static final DecimalFormat NATURAL = new DecimalFormat("###,##0", new DecimalFormatSymbols(Locale.US));
    public static final DecimalFormat DECIMAL = new DecimalFormat(".#########", new DecimalFormatSymbols(Locale.US));

    public static String formatNumber(double number, int digits) {
        return Formatter.formatNumber(number, digits, false);
    }

    public static String formatInt(int number, int digits) {
        return Formatter.formatInt(number, digits, false);
    }

    public static String formatInt(int number, int digits, boolean fixedLength) {
        return Formatter.formatNumber(number, digits, fixedLength);
    }

    public static String formatNumber(double number, int digits, boolean fixedLength) {
        int index;
        if (number < 1000.0) {
            return NATURAL.format(number);
        }
        char[] suffixes = new char[]{'k', 'm', 'b', 't'};
        for (index = -1; number >= 1000.0 && index < suffixes.length - 1; number /= 1000.0, ++index) {
        }
        String suffix = index >= 0 ? String.valueOf(suffixes[index]) : "";
        int availableDigits = digits - suffix.length();
        String pattern = availableDigits > 1 ? "#,##0." + "#".repeat(availableDigits - 1) : "#,##0";
        DecimalFormat formatter = new DecimalFormat(pattern, new DecimalFormatSymbols(Locale.US));
        String formatted = formatter.format(number) + suffix;
        return fixedLength ? String.format("%" + digits + "s", formatted) : formatted;
    }
}

