/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.base.tiles.impls.machine.multi.BaseAdvMultiMachineTileEntity;
import ic2.core.block.base.tiles.impls.machine.multi.BaseColossalMachineTileEntity;
import ic2.core.block.base.tiles.impls.machine.multi.BaseMultiMachineTileEntity;
import ic2.core.block.base.tiles.impls.machine.multi.BasicMultiMachineTileEntity;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BaseMultiBlockMachineInfo
implements IInfoProvider {
    public static final BaseMultiBlockMachineInfo THIS = new BaseMultiBlockMachineInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof BaseMultiMachineTileEntity) {
            BaseMultiMachineTileEntity multiMachine = (BaseMultiMachineTileEntity)blockEntity;
            helper.maxIn(multiMachine.getMaxInput());
            helper.usage(multiMachine.getEnergyPerTick());
            if (multiMachine instanceof BaseAdvMultiMachineTileEntity) {
                BaseAdvMultiMachineTileEntity adv = (BaseAdvMultiMachineTileEntity)multiMachine;
                int speed = adv.getSpeed();
                int maxSpeed = adv.getMaxSpeed();
                Component speedName = adv.getSpeedName();
                double scaledProgress = (double)speed / (double)maxSpeed;
                if (speed > 0) {
                    helper.bar(speed, maxSpeed, (Component)speedName.m_6879_().m_130946_(": " + new DecimalFormat().format(scaledProgress * 100.0) + "%"), -295680);
                }
            }
            if (!multiMachine.isValid) {
                long time = multiMachine.clockTime(512);
                helper.bar((int)time, 512, (Component)this.translate("ic2.multiblock.reform.next", new Object[]{512L - time}), ColorUtils.GRAY);
            }
            if (multiMachine instanceof BasicMultiMachineTileEntity) {
                BasicMultiMachineTileEntity machineTile = (BasicMultiMachineTileEntity)multiMachine;
                if (multiMachine.isMachineWorking() || machineTile.getProgress() > 0.0f) {
                    helper.bar((int)machineTile.getProgress(), (int)machineTile.getMaxProgress(), (Component)this.translate("ic2.probe.progress.full.name", new Object[]{(int)machineTile.getProgress() / 1000, (int)machineTile.getMaxProgress() / 1000}).m_130946_("t"), -16733185);
                }
            }
            if (multiMachine instanceof BaseColossalMachineTileEntity) {
                BaseColossalMachineTileEntity colossalMachine = (BaseColossalMachineTileEntity)multiMachine;
                IntArrayList maxProgressFilter = new IntArrayList();
                IntArrayList progressFilter = new IntArrayList();
                IntIterator activeSlotsIterator = colossalMachine.getActiveSlots();
                while (true) {
                    int index;
                    if (!activeSlotsIterator.hasNext()) {
                        for (int i = 0; i < progressFilter.size(); ++i) {
                            helper.bar(progressFilter.getInt(i), maxProgressFilter.getInt(i), (Component)this.translate("ic2.probe.progress.full.name", new Object[]{progressFilter.getInt(i) / 1000, maxProgressFilter.getInt(i) / 1000}).m_130946_("t"), -16733185);
                        }
                        break;
                    }
                    int slot = activeSlotsIterator.nextInt();
                    int progress = (int)colossalMachine.getProgress(slot);
                    int maxProgress = (int)colossalMachine.getMaxProgress(slot);
                    int maxIndex = maxProgressFilter.indexOf(maxProgress);
                    if (maxIndex == (index = progressFilter.indexOf(progress)) && index != -1) continue;
                    maxProgressFilter.add(maxProgress);
                    progressFilter.add(progress);
                }
            }
            helper.addTankInfo((BlockEntity)multiMachine);
        }
    }
}

