/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.base.tiles.BaseLinkingTileEntity;
import ic2.core.block.generators.tiles.SteamTunnelTileEntity;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.Formatter;
import ic2.jadeplugin.helpers.TextFormatter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SteamTunnelInfo
implements IInfoProvider {
    public static final SteamTunnelInfo THIS = new SteamTunnelInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        BaseLinkingTileEntity linkingTile;
        BlockEntity master;
        if (blockEntity instanceof SteamTunnelTileEntity) {
            SteamTunnelTileEntity steamTunnel = (SteamTunnelTileEntity)blockEntity;
            this.addTunnelInfo(helper, steamTunnel);
            if (!steamTunnel.isValid || steamTunnel.isDynamic()) {
                long time = steamTunnel.clockTime(512);
                helper.bar((int)time, 512, (Component)this.translate("ic2.multiblock.reform.next", new Object[]{512L - time}), ColorUtils.GRAY);
            }
        }
        if (blockEntity instanceof BaseLinkingTileEntity && (master = (linkingTile = (BaseLinkingTileEntity)blockEntity).getMaster()) instanceof SteamTunnelTileEntity) {
            SteamTunnelTileEntity steamTunnel = (SteamTunnelTileEntity)master;
            this.addTunnelInfo(helper, steamTunnel);
        }
    }

    public void addTunnelInfo(JadeHelper helper, SteamTunnelTileEntity steamTunnel) {
        helper.tier(steamTunnel.getSourceTier());
        helper.defaultText("ic2.probe.eu.output.current.name", TextFormatter.GREEN.literal(Formatter.formatNumber(steamTunnel.getEUProduction(), 3)));
        helper.maxOut(steamTunnel.getMaxEnergyOutput());
        helper.addTankInfo((BlockEntity)steamTunnel);
    }
}

