/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.api.items.readers.IWrenchTool;
import ic2.core.block.base.features.IWrenchableTile;
import ic2.core.block.base.features.multiblock.IStructureListener;
import ic2.core.platform.registries.IC2Items;
import ic2.jadeplugin.JadeTags;
import ic2.jadeplugin.elements.CustomTextElement;
import ic2.jadeplugin.helpers.TextFormatter;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;

public class WrenchInfo
implements IBlockComponentProvider {
    public static final WrenchInfo THIS = new WrenchInfo();

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (!iPluginConfig.get(JadeTags.INFO_RENDERER)) {
            return;
        }
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        Player player = blockAccessor.getPlayer();
        ItemStack handHeldStack = player.m_21205_();
        IElement wrenchIcon = iTooltip.getElementHelper().item(IC2Items.WRENCH.m_7968_()).size(new Vec2(16.0f, 16.0f)).align(IElement.Align.LEFT).translate(new Vec2(-2.0f, -5.0f));
        if (blockEntity instanceof IWrenchableTile) {
            boolean showInfo;
            IWrenchableTile tile = (IWrenchableTile)blockEntity;
            double actualRate = ((IWrenchTool)IC2Items.WRENCH.m_5456_()).getActualLoss(IC2Items.WRENCH.m_7968_(), tile.getDropRate(player));
            if (tile instanceof IStructureListener) {
                boolean structureTag = blockAccessor.getServerData().m_128441_("Structure");
                showInfo = !structureTag && actualRate > 0.0;
            } else {
                boolean bl = showInfo = actualRate > 0.0;
            }
            if (showInfo) {
                WrenchInfo.spacerY(iTooltip, 5);
                if (tile.isHarvestWrenchRequired(player)) {
                    iTooltip.add(wrenchIcon);
                    Item item = handHeldStack.m_41720_();
                    if (item instanceof IWrenchTool) {
                        IWrenchTool tool = (IWrenchTool)item;
                        int dropChance = Math.min(Mth.m_14107_((double)(tool.getActualLoss(handHeldStack, tile.getDropRate(player)) * 100.0)), 100);
                        iTooltip.append((Component)TextFormatter.WHITE.translate("ic2.probe.wrenchable.drop_chance.info", TextFormatter.formatPercentage(dropChance).literal("" + dropChance)));
                    } else {
                        iTooltip.append((Component)TextFormatter.GOLD.translate("ic2.probe.wrenchable.info"));
                    }
                } else {
                    iTooltip.add(wrenchIcon);
                    iTooltip.append((Component)TextFormatter.WHITE.translate("ic2.probe.wrenchable.drop_chance.info", TextFormatter.formatPercentage(100).literal("100")));
                    iTooltip.add((IElement)new CustomTextElement((Component)TextFormatter.GOLD.translate("ic2.probe.wrenchable.optional.info")).centered(true));
                }
            }
        }
    }

    public int getDefaultPriority() {
        return 10000;
    }

    public ResourceLocation getUid() {
        return JadeTags.WRENCHABLE;
    }

    public static void spacerY(ITooltip tooltip, int y) {
        tooltip.add(tooltip.getElementHelper().spacer(0, y));
    }
}

