/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers.transport;

import ic2.api.tiles.tubes.TransportedItem;
import ic2.core.block.machines.recipes.ItemStackStrategy;
import ic2.core.block.transport.item.TubeTileEntity;
import ic2.core.utils.helpers.StackUtil;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.TextFormatter;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BasicTubeInfo
implements IInfoProvider {
    public static final BasicTubeInfo THIS = new BasicTubeInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof TubeTileEntity) {
            TubeTileEntity tube = (TubeTileEntity)blockEntity;
            int priority = tube.getPrioritySide();
            if (priority > 0) {
                helper.text((Component)TextFormatter.GOLD.translate("info.tube.prio", TextFormatter.getColor(priority - 1).translate("misc.ic2.side." + Direction.m_122376_((int)(priority - 1)))));
            }
            if (!tube.synchronize) {
                helper.text((Component)TextFormatter.RED.translate("ic2.probe.tube.invisible"));
            }
            NonNullList list = NonNullList.m_122779_();
            if (!tube.items.isEmpty()) {
                Object2IntLinkedOpenCustomHashMap mapped = new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)ItemStackStrategy.INSTANCE);
                int m = tube.items.size();
                for (int i = 0; i < m; ++i) {
                    TransportedItem item = (TransportedItem)tube.items.get(i);
                    mapped.addTo((Object)StackUtil.copyWithSize((ItemStack)item.getServerStack(), (int)1), item.getServerStack().m_41613_());
                }
                mapped.forEach((K, V) -> list.add((Object)StackUtil.copyWithSize((ItemStack)K, (int)V)));
                helper.paddingY(3);
                helper.grid((List<ItemStack>)list, (Component)TextFormatter.GOLD.translate("ic2.probe.tube.transported"));
            }
        }
    }
}

