/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class ComfortHealthOverlay {
    protected static int healthIconsOffset;
    private static final ResourceLocation MOD_ICONS_TEXTURE;
    static ResourceLocation PLAYER_HEALTH_ELEMENT;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ComfortHealthOverlay());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)PLAYER_HEALTH_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                ComfortHealthOverlay.renderComfortOverlay(gui, event.getPoseStack());
            }
        }
    }

    public static void renderComfortOverlay(ForgeGui gui, PoseStack poseStack) {
        boolean isPlayerEligibleForComfort;
        if (!((Boolean)Configuration.COMFORT_HEALTH_OVERLAY.get()).booleanValue()) {
            return;
        }
        healthIconsOffset = gui.leftHeight;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        FoodData stats = player.m_36324_();
        int top = minecraft.m_91268_().m_85446_() - healthIconsOffset + 10;
        int left = minecraft.m_91268_().m_85445_() / 2 - 91;
        boolean bl = isPlayerEligibleForComfort = stats.m_38722_() == 0.0f && player.m_36325_() && !player.m_21023_(MobEffects.f_19605_);
        if (player.m_21124_((MobEffect)ModEffects.COMFORT.get()) != null && isPlayerEligibleForComfort) {
            ComfortHealthOverlay.drawComfortOverlay((Player)player, minecraft, poseStack, left, top);
        }
    }

    public static void drawComfortOverlay(Player player, Minecraft minecraft, PoseStack matrixStack, int left, int top) {
        int ticks = minecraft.f_91065_.m_93079_();
        Random rand = new Random();
        rand.setSeed((long)ticks * 312871L);
        int health = Mth.m_14167_((float)player.m_21223_());
        float absorb = Mth.m_14167_((float)player.m_6103_());
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = (float)attrMaxHealth.m_22135_();
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = ticks % 25;
        }
        int healthRows = Mth.m_14167_((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int comfortSheen = ticks % 50;
        int comfortHeartFrame = comfortSheen % 2;
        int[] textureWidth = new int[]{5, 9};
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOD_ICONS_TEXTURE);
        RenderSystem.m_69478_();
        int healthMaxSingleRow = Mth.m_14167_((float)(Math.min(healthMax, 20.0f) / 2.0f));
        int leftHeightOffset = (healthRows - 1) * rowHeight;
        for (int i = 0; i < healthMaxSingleRow; ++i) {
            int column = i % 10;
            int x = left + column * 8;
            int y = top + leftHeightOffset;
            if (health <= 4) {
                y += rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            if (column == comfortSheen / 2) {
                minecraft.f_91065_.m_93228_(matrixStack, x, y, 0, 9, textureWidth[comfortHeartFrame], 9);
            }
            if (column != comfortSheen / 2 - 1 || comfortHeartFrame != 0) continue;
            minecraft.f_91065_.m_93228_(matrixStack, x + 5, y, 5, 9, 4, 9);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    static {
        MOD_ICONS_TEXTURE = new ResourceLocation("farmersdelight", "textures/gui/fd_icons.png");
        PLAYER_HEALTH_ELEMENT = new ResourceLocation("minecraft", "player_health");
    }
}

