/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import ic2.core.block.base.blocks.BaseFacingBlock;
import ic2.core.block.base.tiles.BaseTileEntity;
import ic2.core.block.base.tiles.impls.BasePersonalTileEntity;
import ic2.core.block.base.tiles.impls.BaseTradeOMatTileEntity;
import ic2.core.platform.player.friends.Action;
import ic2.core.platform.rendering.features.ITextureProvider;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.helpers.Tool;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeHooks;

public class PersonalBlock
extends BaseFacingBlock<BaseTileEntity> {
    public PersonalBlock(String blockName, ITextureProvider provider, BlockEntityType<? extends BaseTileEntity> type) {
        this(blockName, provider, type, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(-1.0f, 6000000.0f));
        this.setHarvestTool(Tool.PICKAXE.withLevel(1));
    }

    protected PersonalBlock(String blockName, ITextureProvider provider, BlockEntityType<? extends BaseTileEntity> type, BlockBehaviour.Properties properties) {
        super(blockName, properties.m_60999_(), provider, type);
        this.setHarvestTool(Tool.PICKAXE.withLevel(1));
    }

    @Override
    protected void setPlaceData(BaseTileEntity tile, BlockState state, LivingEntity placer, ItemStack stack) {
        if (tile instanceof BasePersonalTileEntity) {
            CompoundTag data;
            if (placer instanceof Player) {
                ((BasePersonalTileEntity)tile).setOwner(placer.m_20148_());
            }
            if (!(data = StackUtil.getNbtData(stack).m_128469_("tile_data")).m_128456_()) {
                ((BasePersonalTileEntity)tile).readItemData(data, true);
            }
        } else if (tile instanceof BaseTradeOMatTileEntity && placer instanceof Player) {
            ((BaseTradeOMatTileEntity)tile).setOwner(placer.m_20148_());
        }
    }

    @Override
    public ItemStack createDrop(BlockState state, ItemStack stack, RandomSource rand, BlockEntity tile, boolean wrench) {
        ItemStack drop = new ItemStack((ItemLike)this);
        if (tile instanceof BasePersonalTileEntity) {
            drop.m_41700_("tile_data", (Tag)((BasePersonalTileEntity)tile).writeItemData(new CompoundTag()));
        }
        return drop;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        BasePersonalTileEntity personal;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof BasePersonalTileEntity && (personal = (BasePersonalTileEntity)tile).canDoAction(player.m_20148_(), Action.PERSONAL_BLOCKS_ADMIN, false)) {
            boolean isCorrect = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
            return player.getDigSpeed(state, pos) / (isCorrect ? 240.0f : 800.0f);
        }
        return super.m_5880_(state, player, world, pos);
    }
}

