/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta.text;

import com.nothome.delta.text.SeekableSource;
import java.io.IOException;
import java.nio.CharBuffer;

public class CharBufferSeekableSource
implements SeekableSource {
    private CharBuffer cb;
    private CharBuffer cur;

    public CharBufferSeekableSource(CharBuffer cb) {
        if (cb == null) {
            throw new NullPointerException("cb");
        }
        this.cb = cb;
        try {
            this.seek(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharBufferSeekableSource(CharSequence seq) {
        this(CharBuffer.wrap(seq));
    }

    public void seek(long pos) throws IOException {
        this.cb.rewind();
        this.cur = this.cb.slice();
        if (pos > (long)this.cur.limit()) {
            throw new IOException("pos " + pos + " cannot seek " + this.cur.limit());
        }
        this.cur.position((int)pos);
    }

    public int read(CharBuffer charbuffer) throws IOException {
        return this.cur.read(charbuffer);
    }

    public void close() throws IOException {
    }
}

