/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NamespacedHolderHelper<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ForgeRegistry<T> owner;
    private final Registry<T> self;
    @Nullable
    private final ResourceLocation defaultKey;
    @Nullable
    private final Function<T, Holder.Reference<T>> holderLookup;
    private final Multimap<TagKey<T>, Supplier<T>> optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
    private boolean frozen = false;
    private List<Holder.Reference<T>> holdersSorted;
    private ObjectList<Holder.Reference<T>> holdersById = new ObjectArrayList(256);
    private Map<ResourceLocation, Holder.Reference<T>> holdersByName = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private Map<T, Holder.Reference<T>> holders = new IdentityHashMap<T, Holder.Reference<T>>();
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private Holder.Reference<T> defaultHolder;

    NamespacedHolderHelper(ForgeRegistry<T> owner, Registry<T> self, @Nullable ResourceLocation defaultKey, @Nullable Function<T, Holder.Reference<T>> holderLookup) {
        this.owner = owner;
        this.self = self;
        this.defaultKey = defaultKey;
        this.holderLookup = holderLookup;
    }

    Optional<Holder<T>> getHolder(int id) {
        return id >= 0 && id < this.holdersById.size() ? Optional.ofNullable((Holder)this.holdersById.get(id)) : Optional.empty();
    }

    Optional<Holder<T>> getHolder(ResourceKey<T> key) {
        return Optional.ofNullable((Holder)this.holdersByName.get(key.m_135782_()));
    }

    Optional<Holder<T>> getHolder(ResourceLocation location) {
        return Optional.ofNullable((Holder)this.holdersByName.get(location));
    }

    Optional<Holder<T>> getHolder(T value) {
        return Optional.ofNullable((Holder)this.holders.get(value));
    }

    DataResult<Holder<T>> getOrCreateHolder(ResourceKey<T> key) {
        Holder.Reference ref = this.holdersByName.get(key.m_135782_());
        if (ref == null) {
            if (this.holderLookup != null) {
                return DataResult.error((String)("This registry can't create new holders without value (requested key: " + String.valueOf(key) + ")"));
            }
            if (this.frozen) {
                return DataResult.error((String)("Registry is already frozen (trying to add key " + String.valueOf(key) + ")"));
            }
            ref = Holder.Reference.m_205766_(this.self, key);
            this.holdersByName.put(key.m_135782_(), ref);
        }
        return DataResult.success(ref);
    }

    Holder<T> getOrCreateHolderOrThrow(ResourceKey<T> key) {
        return (Holder)this.getOrCreateHolder(key).getOrThrow(false, msg -> {
            throw new IllegalStateException((String)msg);
        });
    }

    Optional<Holder<T>> getRandom(RandomSource rand) {
        Optional<Holder<T>> ret = Util.m_214676_(this.getSortedHolders(), (RandomSource)rand).map(Holder::m_205706_);
        if (this.defaultKey != null) {
            ret = ret.or(() -> Optional.of(this.defaultHolder));
        }
        return ret;
    }

    Stream<Holder.Reference<T>> holders() {
        return this.getSortedHolders().stream();
    }

    boolean isKnownTagName(TagKey<T> name) {
        return this.tags.containsKey(name);
    }

    Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map(e -> Pair.of((Object)((TagKey)e.getKey()), (Object)((HolderSet.Named)e.getValue())));
    }

    HolderSet.Named<T> getOrCreateTag(TagKey<T> name) {
        HolderSet.Named<T> named = this.tags.get(name);
        if (named == null) {
            named = this.createTag(name);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            map.put(name, named);
            this.tags = map;
        }
        return named;
    }

    void addOptionalTag(TagKey<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        this.optionalTags.putAll(name, defaults);
    }

    Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    Registry<T> freeze() {
        List<Holder.Reference> intrusive;
        this.frozen = true;
        List<ResourceLocation> unregisterd = this.holdersByName.entrySet().stream().filter(e -> !((Holder.Reference)e.getValue()).m_203633_()).map(e -> (ResourceLocation)e.getKey()).sorted().toList();
        if (!unregisterd.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.self.m_123023_()) + ": " + unregisterd.stream().map(ResourceLocation::toString).collect(Collectors.joining(", \n\t")));
        }
        if (this.holderLookup != null && !(intrusive = this.holders.values().stream().filter(h -> h.getType() == Holder.Reference.Type.INTRUSIVE && !h.m_203633_()).toList()).isEmpty()) {
            throw new IllegalStateException("Some intrusive holders were not added to registry: " + String.valueOf(intrusive));
        }
        return this.self;
    }

    Holder.Reference<T> createIntrusiveHolder(T value) {
        if (this.holderLookup == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
        return this.holders.computeIfAbsent(value, k -> Holder.Reference.m_205763_(this.self, (Object)value));
    }

    Optional<HolderSet.Named<T>> getTag(TagKey<T> name) {
        return Optional.ofNullable(this.tags.get(name));
    }

    void bindTags(Map<TagKey<T>, List<Holder<T>>> newTags) {
        IdentityHashMap<Holder.Reference, List> holderToTag = new IdentityHashMap<Holder.Reference, List>();
        this.holdersByName.values().forEach(v -> holderToTag.put((Holder.Reference)v, new ArrayList()));
        newTags.forEach((name, values) -> values.forEach(holder -> this.addTagToHolder(holderToTag, (TagKey<T>)name, (Holder<T>)holder)));
        Sets.SetView set = Sets.difference(this.tags.keySet(), newTags.keySet());
        if (!set.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", (Object)this.self.m_123023_(), (Object)set.stream().map(k -> k.f_203868_().toString()).sorted().collect(Collectors.joining(", \n\t")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> tmpTags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
        newTags.forEach((k, v) -> tmpTags.computeIfAbsent((TagKey<T>)k, this::createTag).m_205835_(v));
        Sets.SetView defaultedTags = Sets.difference((Set)this.optionalTags.keySet(), newTags.keySet());
        defaultedTags.forEach(name -> {
            List<Holder> defaults = this.optionalTags.get(name).stream().map(valueSupplier -> this.getHolder(valueSupplier.get()).orElse(null)).filter(Objects::nonNull).distinct().toList();
            defaults.forEach(holder -> this.addTagToHolder(holderToTag, (TagKey<T>)name, (Holder<T>)holder));
            tmpTags.computeIfAbsent((TagKey<T>)name, this::createTag).m_205835_(defaults);
        });
        holderToTag.forEach(Holder.Reference::m_205769_);
        this.tags = tmpTags;
        this.owner.onBindTags(this.tags, (Set<TagKey<T>>)defaultedTags);
    }

    private void addTagToHolder(Map<Holder.Reference<T>, List<TagKey<T>>> holderToTag, TagKey<T> name, Holder<T> holder) {
        if (!holder.m_203401_(this.self)) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(name) + " containing value " + String.valueOf(holder) + " from outside registry " + String.valueOf(this));
        }
        if (!(holder instanceof Holder.Reference)) {
            throw new IllegalStateException("Found direct holder " + String.valueOf(holder) + " value in tag " + String.valueOf(name));
        }
        holderToTag.get((Holder.Reference)holder).add(name);
    }

    void resetTags() {
        this.tags.values().forEach(t -> t.m_205835_(List.of()));
        this.holders.values().forEach(v -> v.m_205769_(Set.of()));
    }

    void unfreeze() {
        this.frozen = false;
    }

    boolean isFrozen() {
        return this.frozen;
    }

    boolean isIntrusive() {
        return this.holderLookup != null;
    }

    @Nullable
    Holder<T> onAdded(RegistryManager stage, int id, ResourceKey<T> key, T newValue, T oldValue) {
        if (!(stage == RegistryManager.ACTIVE || this.holderLookup != null && stage.isStaging())) {
            return null;
        }
        Holder.Reference<T> newHolder = this.getHolder(key, newValue);
        this.holdersById.size(Math.max(this.holdersById.size(), id + 1));
        this.holdersById.set(id, newHolder);
        this.holdersByName.put(key.m_135782_(), newHolder);
        this.holders.put(newValue, newHolder);
        newHolder.m_205775_(key, newValue);
        this.holdersSorted = null;
        if (this.defaultKey != null && this.defaultKey.equals((Object)key.m_135782_())) {
            this.defaultHolder = newHolder;
        }
        return newHolder;
    }

    private HolderSet.Named<T> createTag(TagKey<T> name) {
        return new HolderSet.Named(this.self, name);
    }

    private Holder.Reference<T> getHolder(ResourceKey<T> key, T value) {
        if (this.holderLookup != null) {
            return this.holderLookup.apply(value);
        }
        return this.holdersByName.computeIfAbsent(key.m_135782_(), k -> Holder.Reference.m_205766_(this.self, (ResourceKey)key));
    }

    private List<Holder.Reference<T>> getSortedHolders() {
        if (this.holdersSorted == null) {
            this.holdersSorted = this.holdersById.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersSorted;
    }
}

