/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.client.render.be;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.quark.addons.oddities.block.be.PipeBlockEntity;
import vazkii.quark.addons.oddities.module.PipesModule;

public class PipeRenderer
implements BlockEntityRenderer<PipeBlockEntity> {
    private static final ModelResourceLocation LOCATION_MODEL = new ModelResourceLocation(new ResourceLocation("quark", "extra/pipe_flare"), "inventory");
    private final Random random = new Random();

    public PipeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PipeBlockEntity te, float partialTicks, PoseStack matrix, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        ItemRenderer render = Minecraft.m_91087_().m_91291_();
        Iterator<PipeBlockEntity.PipeItem> items = te.getItemIterator();
        if (PipesModule.renderPipeItems) {
            while (items.hasNext()) {
                this.renderItem(items.next(), render, matrix, buffer, partialTicks, light, overlay);
            }
        }
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
        ModelManager modelmanager = blockrendererdispatcher.m_110907_().m_110881_();
        BakedModel model = modelmanager.m_119422_(LOCATION_MODEL);
        for (Direction d : Direction.values()) {
            this.renderFlare(te, blockrendererdispatcher, model, matrix, buffer, partialTicks, light, overlay, d);
        }
        matrix.m_85849_();
    }

    private void renderFlare(PipeBlockEntity te, BlockRenderDispatcher disp, BakedModel model, PoseStack matrix, MultiBufferSource buffer, float partial, int light, int overlay, Direction dir) {
        PipeBlockEntity.ConnectionType type = te.getConnectionTo(dir);
        if (type.isFlared) {
            matrix.m_85836_();
            switch (dir.m_122434_()) {
                case X: {
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(-dir.m_122435_()));
                    break;
                }
                case Z: {
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(dir.m_122435_()));
                    break;
                }
                case Y: {
                    matrix.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                    if (dir != Direction.UP) break;
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                }
            }
            matrix.m_85837_(-0.5, -0.5, type.getFlareShift(te));
            disp.m_110937_().m_111067_(matrix.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
            matrix.m_85849_();
        }
    }

    private void renderItem(PipeBlockEntity.PipeItem item, ItemRenderer render, PoseStack matrix, MultiBufferSource buffer, float partial, int light, int overlay) {
        matrix.m_85836_();
        float scale = 0.4f;
        float fract = item.getTimeFract(partial);
        float shiftFract = fract - 0.5f;
        Direction face = item.outgoingFace;
        if ((double)fract < 0.5) {
            face = item.incomingFace.m_122424_();
        }
        float offX = (float)face.m_122429_() * 1.0f;
        float offY = (float)face.m_122430_() * 1.0f;
        float offZ = (float)face.m_122431_() * 1.0f;
        matrix.m_85837_((double)(offX * shiftFract), (double)(offY * shiftFract), (double)(offZ * shiftFract));
        matrix.m_85841_(scale, scale, scale);
        float speed = 4.0f;
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(((float)item.timeInWorld + partial) * speed));
        int seed = item.stack.m_41619_() ? 187 : Item.m_41393_((Item)item.stack.m_41720_());
        this.random.setSeed(seed);
        int count = this.getModelCount(item.stack);
        for (int i = 0; i < count; ++i) {
            matrix.m_85836_();
            if (i > 0) {
                float spread = 0.15f;
                float x = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                float y = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                float z = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                matrix.m_85837_((double)x, (double)y, (double)z);
            }
            render.m_174269_(item.stack, ItemTransforms.TransformType.FIXED, light, overlay, matrix, buffer, 0);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    protected int getModelCount(ItemStack stack) {
        if (stack.m_41613_() > 48) {
            return 5;
        }
        if (stack.m_41613_() > 32) {
            return 4;
        }
        if (stack.m_41613_() > 16) {
            return 3;
        }
        if (stack.m_41613_() > 1) {
            return 2;
        }
        return 1;
    }
}

