/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.magnetsystem;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.quark.addons.oddities.block.be.MagnetBlockEntity;
import vazkii.quark.addons.oddities.magnetsystem.DefaultMoveActions;
import vazkii.quark.addons.oddities.module.MagnetsModule;
import vazkii.quark.api.IMagnetMoveAction;
import vazkii.quark.api.IMagnetTracker;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.RecipeCrawlHandler;

public class MagnetSystem {
    private static final HashSet<Block> magnetizableBlocks = new HashSet();
    private static final HashMap<Block, IMagnetMoveAction> BLOCK_MOVE_ACTIONS = new HashMap();

    public static IMagnetMoveAction getMoveAction(Block block) {
        return BLOCK_MOVE_ACTIONS.get(block);
    }

    public static LazyOptional<IMagnetTracker> getCapability(Level world) {
        return world.getCapability(QuarkCapabilities.MAGNET_TRACKER_CAPABILITY);
    }

    public static void tick(boolean start, Level level) {
        if (start) {
            MagnetSystem.getCapability(level).ifPresent(IMagnetTracker::clear);
        } else {
            MagnetSystem.getCapability(level).ifPresent(magnetTracker -> {
                for (BlockPos pos : magnetTracker.getTrackedPositions()) {
                    magnetTracker.actOnForces(pos);
                }
                magnetTracker.clear();
            });
        }
    }

    public static void onRecipeReset() {
        magnetizableBlocks.clear();
    }

    public static void onDigest() {
        RecipeCrawlHandler.recursivelyFindCraftedItemsFromStrings(MagnetsModule.magneticDerivationList, MagnetsModule.magneticWhitelist, MagnetsModule.magneticBlacklist, i -> {
            if (i instanceof BlockItem) {
                BlockItem bi = (BlockItem)i;
                magnetizableBlocks.add(bi.m_40614_());
            }
        });
    }

    public static void applyForce(Level world, BlockPos pos, int magnitude, boolean pushing, Direction dir, int distance, BlockPos origin) {
        MagnetSystem.getCapability(world).ifPresent(magnetTracker -> magnetTracker.applyForce(pos, magnitude, pushing, dir, distance, origin));
    }

    public static PushReaction getPushAction(MagnetBlockEntity magnet, BlockPos pos, BlockState state, Direction moveDir) {
        Level world = magnet.m_58904_();
        if (world != null && MagnetSystem.isBlockMagnetic(state)) {
            BlockPos targetLocation = pos.m_121945_(moveDir);
            BlockState stateAtTarget = world.m_8055_(targetLocation);
            if (stateAtTarget.m_60795_()) {
                return PushReaction.IGNORE;
            }
            if (stateAtTarget.m_60811_() == PushReaction.DESTROY) {
                return PushReaction.DESTROY;
            }
        }
        return PushReaction.BLOCK;
    }

    public static boolean isBlockMagnetic(BlockState state) {
        Block block = state.m_60734_();
        if ((block == Blocks.f_50039_ || block == Blocks.f_50032_) && ((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
            return false;
        }
        return block != MagnetsModule.magnet && (magnetizableBlocks.contains(block) || BLOCK_MOVE_ACTIONS.containsKey(block) || block instanceof IMagnetMoveAction);
    }

    static {
        DefaultMoveActions.addActions(BLOCK_MOVE_ACTIONS);
    }
}

