/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config;

import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.api.config.IConfigCategory;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.api.config.IConfigObject;
import vazkii.quark.base.client.config.AbstractConfigElement;
import vazkii.quark.base.client.config.ConfigObject;
import vazkii.quark.base.client.config.external.ExternalCategory;
import vazkii.quark.base.client.config.screen.CategoryScreen;
import vazkii.quark.base.client.config.screen.WidgetWrapper;
import vazkii.quark.base.client.config.screen.inputtable.IInputtableConfigType;
import vazkii.quark.base.client.config.screen.widgets.IWidgetProvider;
import vazkii.quark.base.client.config.screen.widgets.PencilButton;
import vazkii.quark.base.module.config.type.IConfigType;

public class ConfigCategory
extends AbstractConfigElement
implements IConfigCategory,
IWidgetProvider {
    public final List<IConfigElement> subElements = new LinkedList<IConfigElement>();
    private final String path;
    private final int depth;
    protected final Object holderObject;
    private boolean dirty = false;

    public ConfigCategory(String name, String comment, IConfigCategory parent, Object holderObject) {
        super(name, comment, parent);
        this.holderObject = holderObject;
        if (parent == null || parent instanceof ExternalCategory) {
            this.path = name;
            this.depth = 0;
        } else {
            this.path = String.format("%s.%s", parent.getPath(), name);
            this.depth = 1 + parent.getDepth();
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public List<IConfigElement> getSubElements() {
        return this.subElements;
    }

    @Override
    public String getDefaultGuiDisplayName() {
        return WordUtils.capitalize((String)this.getName().replaceAll("_", " "));
    }

    @Override
    public void updateDirty() {
        this.dirty = this.shouldBeDirty();
        if (this.parent != null) {
            this.parent.updateDirty();
        }
    }

    protected boolean shouldBeDirty() {
        if (this.isInputtable()) {
            return ((IInputtableConfigType)this.holderObject).isDirty();
        }
        for (IConfigElement sub : this.subElements) {
            if (!sub.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clean() {
        this.subElements.forEach(IConfigElement::clean);
        this.dirty = false;
    }

    @Override
    public void save() {
        for (IConfigElement element : this.subElements) {
            if (!this.isInputtable() && !element.isDirty()) continue;
            element.save();
        }
    }

    private boolean isInputtable() {
        return this.holderObject instanceof IInputtableConfigType;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void refresh() {
        this.subElements.forEach(IConfigElement::refresh);
    }

    @Override
    public void reset(boolean hard) {
        this.subElements.forEach(e -> e.reset(hard));
    }

    @Override
    public IConfigCategory addCategory(String name, @Nonnull String comment, Object holderObject) {
        ConfigCategory newCategory = new ConfigCategory(name, comment, this, holderObject);
        if (holderObject instanceof IConfigType) {
            IConfigType configType = (IConfigType)holderObject;
            configType.setCategory(newCategory);
        }
        return this.addCategory(newCategory);
    }

    public IConfigCategory addCategory(IConfigCategory category) {
        this.subElements.add(category);
        return category;
    }

    @Override
    public <T> IConfigObject<T> addEntry(ForgeConfigSpec.ConfigValue<T> value, T default_, Supplier<T> getter, @Nonnull String comment, @Nonnull Predicate<Object> restriction) {
        IConfigObject<T> obj = ConfigObject.create(value, comment, default_, getter, restriction, this);
        this.addEntry(obj, default_);
        return obj;
    }

    public <T> void addEntry(IConfigObject<T> obj, T default_) {
        this.subElements.add(obj);
    }

    @Override
    public void close() {
        this.subElements.removeIf(e -> e instanceof ConfigCategory && ((ConfigCategory)e).subElements.isEmpty());
        Collections.sort(this.subElements);
    }

    @Override
    public void addWidgets(CategoryScreen parent, IConfigElement element, List<WidgetWrapper> widgets) {
        Object object = this.holderObject;
        if (object instanceof IWidgetProvider) {
            IWidgetProvider widgetProvider = (IWidgetProvider)object;
            widgetProvider.addWidgets(parent, element, widgets);
        } else {
            widgets.add(new WidgetWrapper((AbstractWidget)new PencilButton(230, 3, parent.categoryLink(this))));
        }
    }

    @Override
    public void print(String pad, PrintStream stream) {
        stream.println();
        super.print(pad, stream);
        stream.printf("%s[%s]%n", pad, this.path);
        String newPad = String.format("\t%s", pad);
        this.subElements.forEach(e -> e.print(newPad, stream));
    }

    @Override
    public String getSubtitle() {
        Object ret;
        if (this.holderObject != null && this.holderObject instanceof IWidgetProvider) {
            ret = ((IWidgetProvider)this.holderObject).getSubtitle();
        } else {
            int size = this.subElements.size();
            Object object = ret = size == 1 ? I18n.m_118938_((String)"quark.gui.config.onechild", (Object[])new Object[0]) : I18n.m_118938_((String)"quark.gui.config.nchildren", (Object[])new Object[]{this.subElements.size()});
        }
        if (((String)ret).length() > 30) {
            ret = ((String)ret).substring(0, 27) + "...";
        }
        return ret;
    }

    @Override
    public int compareTo(@Nonnull IConfigElement o) {
        if (o == this) {
            return 0;
        }
        if (!(o instanceof ConfigCategory)) {
            return 1;
        }
        ConfigCategory cat = (ConfigCategory)o;
        return this.name.compareTo(cat.name);
    }
}

