/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.sync;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.structural.S2CUpdateFlag;

public class SyncedFlagHandler {
    private static ConfigFlagManager flagManager;
    private static List<String> allFlags;
    private static final WeakHashMap<PacketListener, Set<String>> flagsFromServer;
    private static final WeakHashMap<ServerPlayer, Set<String>> flagsFromPlayers;

    public static void setupFlagManager(ConfigFlagManager manager, List<String> flags) {
        flagManager = manager;
        allFlags = flags;
    }

    public static BitSet compileFlagInfo() {
        BitSet set = new BitSet();
        int i = 0;
        for (String flag : allFlags) {
            set.set(i++, flagManager.getFlag(flag));
        }
        return set;
    }

    public static int expectedLength() {
        return allFlags.size();
    }

    public static int expectedHash() {
        return allFlags.hashCode();
    }

    private static Set<String> decodeFlags(BitSet bitSet) {
        HashSet<String> enabledFlags = new HashSet<String>();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            enabledFlags.add(allFlags.get(i));
            i = bitSet.nextSetBit(i + 1);
        }
        return enabledFlags;
    }

    public static void receiveFlagInfoFromPlayer(ServerPlayer player, BitSet bitSet) {
        flagsFromPlayers.put(player, SyncedFlagHandler.decodeFlags(bitSet));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveFlagInfoFromServer(BitSet bitSet) {
        flagsFromServer.put((PacketListener)Minecraft.m_91087_().m_91403_(), SyncedFlagHandler.decodeFlags(bitSet));
    }

    public static void sendFlagInfoToPlayers() {
        QuarkNetwork.sendToPlayers(S2CUpdateFlag.createPacket(), flagsFromPlayers.keySet());
    }

    public static boolean getFlagForPlayer(ServerPlayer player, String flag) {
        Set<String> enabledFlags = flagsFromPlayers.get(player);
        if (enabledFlags == null) {
            return flagManager.getFlag(flag);
        }
        return enabledFlags.contains(flag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean getFlagForServer(String flag) {
        for (PacketListener listener : flagsFromServer.keySet()) {
            Set<String> enabledFlags = flagsFromServer.get(listener);
            if (enabledFlags == null) continue;
            return enabledFlags.contains(flag);
        }
        return flagManager.getFlag(flag);
    }

    static {
        flagsFromServer = new WeakHashMap();
        flagsFromPlayers = new WeakHashMap();
    }
}

