/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public final class IafConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRE_DRAGON_ROOST = IafConfiguredFeatures.registerKey("fire_dragon_roost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_DRAGON_ROOST = IafConfiguredFeatures.registerKey("ice_dragon_roost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIGHTNING_DRAGON_ROOST = IafConfiguredFeatures.registerKey("lightning_dragon_roost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRE_DRAGON_CAVE = IafConfiguredFeatures.registerKey("fire_dragon_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_DRAGON_CAVE = IafConfiguredFeatures.registerKey("ice_dragon_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIGHTNING_DRAGON_CAVE = IafConfiguredFeatures.registerKey("lightning_dragon_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CYCLOPS_CAVE = IafConfiguredFeatures.registerKey("cyclops_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PIXIE_VILLAGE = IafConfiguredFeatures.registerKey("pixie_village");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SIREN_ISLAND = IafConfiguredFeatures.registerKey("siren_island");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HYDRA_CAVE = IafConfiguredFeatures.registerKey("hydra_cave");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MYRMEX_HIVE_DESERT = IafConfiguredFeatures.registerKey("myrmex_hive_desert");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MYRMEX_HIVE_JUNGLE = IafConfiguredFeatures.registerKey("myrmex_hive_jungle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DEATH_WORM = IafConfiguredFeatures.registerKey("spawn_death_worm");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DRAGON_SKELETON_L = IafConfiguredFeatures.registerKey("spawn_dragon_skeleton_lightning");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DRAGON_SKELETON_F = IafConfiguredFeatures.registerKey("spawn_dragon_skeleton_fire");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_DRAGON_SKELETON_I = IafConfiguredFeatures.registerKey("spawn_dragon_skeleton_ice");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_HIPPOCAMPUS = IafConfiguredFeatures.registerKey("spawn_hippocampus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_SEA_SERPENT = IafConfiguredFeatures.registerKey("spawn_sea_serpent");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_STYMPHALIAN_BIRD = IafConfiguredFeatures.registerKey("spawn_stymphalian_bird");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPAWN_WANDERING_CYCLOPS = IafConfiguredFeatures.registerKey("spawn_wandering_cyclops");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = IafConfiguredFeatures.registerKey("silver_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SAPPHIRE_ORE = IafConfiguredFeatures.registerKey("sapphire_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRE_LILY = IafConfiguredFeatures.registerKey("fire_lily");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROST_LILY = IafConfiguredFeatures.registerKey("frost_lily");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIGHTNING_LILY = IafConfiguredFeatures.registerKey("lightning_lily");
    private static final Function<Block, RandomPatchConfiguration> FLOWER_CONFIGURATION = block -> FeatureUtils.m_206470_((int)8, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block.m_49966_().m_60734_()))));

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("iceandfire", name));
    }

    public static Map<ResourceLocation, ConfiguredFeature<?, ?>> gather(RegistryOps<JsonElement> registryOps) {
        HashMap entries = new HashMap();
        entries.put(FIRE_DRAGON_ROOST.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.FIRE_DRAGON_ROOST.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(ICE_DRAGON_ROOST.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.ICE_DRAGON_ROOST.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(LIGHTNING_DRAGON_ROOST.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.LIGHTNING_DRAGON_ROOST.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(FIRE_DRAGON_CAVE.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.FIRE_DRAGON_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(ICE_DRAGON_CAVE.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.ICE_DRAGON_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(LIGHTNING_DRAGON_CAVE.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.LIGHTNING_DRAGON_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(CYCLOPS_CAVE.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.CYCLOPS_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(PIXIE_VILLAGE.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.PIXIE_VILLAGE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SIREN_ISLAND.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SIREN_ISLAND.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(HYDRA_CAVE.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.HYDRA_CAVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(MYRMEX_HIVE_DESERT.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.MYRMEX_HIVE_DESERT.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(MYRMEX_HIVE_JUNGLE.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.MYRMEX_HIVE_JUNGLE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_DEATH_WORM.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DEATH_WORM.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_DRAGON_SKELETON_L.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DRAGON_SKELETON_L.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_DRAGON_SKELETON_F.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DRAGON_SKELETON_F.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_DRAGON_SKELETON_I.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_DRAGON_SKELETON_I.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_HIPPOCAMPUS.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_HIPPOCAMPUS.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_SEA_SERPENT.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_SEA_SERPENT.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_STYMPHALIAN_BIRD.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_STYMPHALIAN_BIRD.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SPAWN_WANDERING_CYCLOPS.m_135782_(), new ConfiguredFeature((Feature)IafWorldRegistry.SPAWN_WANDERING_CYCLOPS.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        entries.put(SILVER_ORE.m_135782_(), IafConfiguredFeatures.createSilverOre());
        entries.put(SAPPHIRE_ORE.m_135782_(), new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_144266_), ((Block)IafBlockRegistry.SAPPHIRE_ORE.get()).m_49966_(), 4, 0.5f)));
        entries.put(FIRE_LILY.m_135782_(), new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FLOWER_CONFIGURATION.apply((Block)IafBlockRegistry.FIRE_LILY.get())));
        entries.put(FROST_LILY.m_135782_(), new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FLOWER_CONFIGURATION.apply((Block)IafBlockRegistry.FROST_LILY.get())));
        entries.put(LIGHTNING_LILY.m_135782_(), new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FLOWER_CONFIGURATION.apply((Block)IafBlockRegistry.LIGHTNING_LILY.get())));
        return entries;
    }

    private static ConfiguredFeature<?, ?> createSilverOre() {
        TagMatchTest stoneOreRule = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateOreRule = new TagMatchTest(BlockTags.f_144267_);
        List<OreConfiguration.TargetBlockState> silverOreConfiguration = List.of(OreConfiguration.m_161021_((RuleTest)stoneOreRule, (BlockState)((Block)IafBlockRegistry.SILVER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOreRule, (BlockState)((Block)IafBlockRegistry.DEEPSLATE_SILVER_ORE.get()).m_49966_()));
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(silverOreConfiguration, 4));
    }
}

